/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.statistic;

import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.statistic.AbstractColumnStatistic;

public class MultiColumnStatistic
extends AbstractColumnStatistic {
    private static final long serialVersionUID = 2141252366056112668L;
    protected AbstractColumnStatistic[] m_Statistics;

    public String globalInfo() {
        return "Combines the statistics calculated from the specified statistic generators.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("statistic", "statistics", (Object)new AbstractColumnStatistic[0]);
    }

    public void setStatistics(AbstractColumnStatistic[] value) {
        this.m_Statistics = value;
        this.reset();
    }

    public AbstractColumnStatistic[] getStatistics() {
        return this.m_Statistics;
    }

    public String statisticsTipText() {
        return "The statistics to calculate.";
    }

    @Override
    protected void preVisit(SpreadSheet sheet, int colIndex) {
        for (AbstractColumnStatistic stat : this.m_Statistics) {
            stat.preVisit(sheet, colIndex);
        }
    }

    @Override
    protected void doVisit(Row row, int colIndex) {
        for (AbstractColumnStatistic stat : this.m_Statistics) {
            stat.doVisit(row, colIndex);
        }
    }

    @Override
    protected SpreadSheet postVisit(SpreadSheet sheet, int colIndex) {
        SpreadSheet result = this.createOutputHeader();
        for (AbstractColumnStatistic stat : this.m_Statistics) {
            SpreadSheet sub = stat.postVisit(sheet, colIndex);
            if (sub == null) continue;
            for (Row row : sub.rows()) {
                result.addRow().assign(row);
            }
        }
        return result;
    }
}

