/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.statistic.AbstractColumnStatistic;
import adams.data.spreadsheet.statistic.Mean;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;

public class SpreadSheetColumnStatistic
extends AbstractSpreadSheetTransformer {
    private static final long serialVersionUID = 4527040722924866539L;
    protected SpreadSheetColumnIndex m_Column;
    protected AbstractColumnStatistic m_Statistic;

    public String globalInfo() {
        return "Generates statistics for a chosen colunm.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("column", "column", (Object)new SpreadSheetColumnIndex("first"));
        this.m_OptionManager.add("statistic", "statistic", (Object)new Mean());
    }

    public void setColumn(SpreadSheetColumnIndex value) {
        this.m_Column = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The column to generate the statistics for.";
    }

    public void setStatistic(AbstractColumnStatistic value) {
        this.m_Statistic = value;
        this.reset();
    }

    public AbstractColumnStatistic getStatistic() {
        return this.m_Statistic;
    }

    public String statisticTipText() {
        return "The statistic to generate for the specified column.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"column", (Object)((Object)this.m_Column), (String)"col: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"statistic", (Object)((Object)this.m_Statistic), (String)", stat: ");
        return result;
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet input = (SpreadSheet)this.m_InputToken.getPayload();
        this.m_Column.setData(input);
        int column = this.m_Column.getIntIndex();
        if (column == -1) {
            result = "Failed to locate column: " + (Object)((Object)this.m_Column);
        } else {
            SpreadSheet output = this.m_Statistic.generate(input, column);
            this.m_OutputToken = new Token((Object)output);
        }
        return result;
    }
}

