/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;

public class SpreadSheetCopyColumns
extends AbstractSpreadSheetTransformer {
    private static final long serialVersionUID = 9030574317512531337L;
    protected SpreadSheetColumnRange m_Columns;
    protected SpreadSheetColumnIndex m_Position;
    protected boolean m_After;
    protected String m_Prefix;

    public String globalInfo() {
        return "Copies a range of columns to a specific position in the spreadsheets coming through.";
    }

    protected void initialize() {
        super.initialize();
        this.m_Position = new SpreadSheetColumnIndex();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("columns", "columns", (Object)new SpreadSheetColumnRange("first-last"));
        this.m_OptionManager.add("position", "position", (Object)new SpreadSheetColumnIndex("first"));
        this.m_OptionManager.add("after", "after", (Object)false);
        this.m_OptionManager.add("prefix", "prefix", (Object)"Copy-");
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"columns", (Object)((Object)this.m_Columns), (String)"columns: ");
        result = QuickInfoHelper.hasVariable((OptionHandler)this, (String)"after") ? result + ", at/after: " : (this.m_After ? result + ", after: " : result + ", at: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"position", (Object)((Object)this.m_Position));
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"prefix", (Object)(this.m_Prefix.length() > 0 ? this.m_Prefix : null), (String)", prefix: ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    public void setColumns(SpreadSheetColumnRange value) {
        this.m_Columns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "The range of columns to copy";
    }

    public void setPosition(SpreadSheetColumnIndex value) {
        this.m_Position = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getPosition() {
        return this.m_Position;
    }

    public String positionTipText() {
        return "The position where to insert the column.";
    }

    public void setAfter(boolean value) {
        this.m_After = value;
        this.reset();
    }

    public boolean getAfter() {
        return this.m_After;
    }

    public String afterTipText() {
        return "If enabled, the column is inserted after the position instead of at the position.";
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix to use for the column headers, can be empty.";
    }

    protected String doExecute() {
        int i;
        String result = null;
        SpreadSheet sheetOld = (SpreadSheet)this.m_InputToken.getPayload();
        SpreadSheet sheetNew = sheetOld.getHeader();
        this.m_Columns.setSpreadSheet(sheetOld);
        int[] fromPos = this.m_Columns.getIntIndices();
        int[] toPos = new int[fromPos.length];
        this.m_Position.setSpreadSheet(sheetOld);
        int pos = this.m_Position.getIntIndex();
        if (this.m_After) {
            ++pos;
        }
        for (i = 0; i < toPos.length; ++i) {
            toPos[i] = pos + i;
        }
        for (i = 0; i < fromPos.length; ++i) {
            String header = sheetOld.getHeaderRow().getContent(fromPos[i]);
            sheetNew.insertColumn(toPos[i], this.m_Prefix + header);
        }
        for (DataRow rowOld : sheetOld.rows()) {
            DataRow rowNew = sheetNew.addRow();
            for (String key : rowOld.cellKeys()) {
                rowNew.addCell(key).assign(rowOld.getCell(key));
            }
            for (i = 0; i < fromPos.length; ++i) {
                Cell cell = rowOld.getCell(fromPos[i]);
                rowNew.getCell(toPos[i]).assign(cell);
            }
        }
        this.m_OutputToken = new Token((Object)sheetNew);
        return result;
    }
}

