/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.plotgenerator;

import adams.core.QuickInfoSupporter;
import adams.core.Utils;
import adams.core.option.AbstractOptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.container.SequencePlotterContainer;
import java.util.List;

public abstract class AbstractPlotGenerator
extends AbstractOptionHandler
implements QuickInfoSupporter {
    private static final long serialVersionUID = -7535085726098063330L;
    public static final String MISSING_CELL_VALUE = "MISSING";
    protected double m_DefaultCellValue;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("default-cell-value", "defaultCellValue", (Object)-1.0);
    }

    public void setDefaultCellValue(double value) {
        this.m_DefaultCellValue = value;
        this.reset();
    }

    public double getDefaultCellValue() {
        return this.m_DefaultCellValue;
    }

    public String defaultCellValueTipText() {
        return "The default value for missing or non-numeric cells.";
    }

    public String getQuickInfo() {
        return null;
    }

    protected void check(SpreadSheet sheet) {
        if (sheet == null) {
            throw new IllegalStateException("No spreadsheet provided!");
        }
    }

    protected String getCellString(Row row, int index) {
        String result = MISSING_CELL_VALUE;
        Cell cell = row.getCell(index);
        if (cell != null && !cell.isMissing()) {
            result = cell.getContent();
        }
        return result;
    }

    protected Comparable getCellValue(Row row, int index, Comparable defaultValue) {
        Object result = defaultValue;
        Cell cell = row.getCell(index);
        if (cell != null && !cell.isMissing()) {
            result = cell.isNumeric() ? new Double(Utils.toDouble((String)cell.getContent())) : (cell.isTime() ? new Double(cell.toTime().getTime()) : (cell.isDate() ? new Double(cell.toDate().getTime()) : (cell.isDateTime() ? new Double(cell.toDateTime().getTime()) : cell.getContent())));
        }
        return result;
    }

    protected Object getCellObject(Row row, int index, Object defaultValue) {
        Object result = defaultValue;
        Cell cell = row.getCell(index);
        if (cell != null && !cell.isMissing()) {
            result = cell.getNative();
        }
        return result;
    }

    protected Comparable getCellValue(Row row, int index) {
        return this.getCellValue(row, index, Double.valueOf(this.m_DefaultCellValue));
    }

    protected abstract List<SequencePlotterContainer> doGenerate(SpreadSheet var1);

    public List<SequencePlotterContainer> generate(SpreadSheet sheet) {
        this.check(sheet);
        return this.doGenerate(sheet);
    }
}

