/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.plotgenerator;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.transformer.plotgenerator.AbstractPlotGenerator;
import java.util.ArrayList;
import java.util.List;

public class XYWithErrorsPlotGenerator
extends AbstractPlotGenerator {
    private static final long serialVersionUID = 2881757430571628883L;
    protected SpreadSheetColumnIndex m_YColumn;
    protected SpreadSheetColumnIndex m_XColumn;
    protected SpreadSheetColumnRange m_YErrorColumns;
    protected SpreadSheetColumnRange m_XErrorColumns;
    protected SpreadSheetColumnRange m_MetaDataColumns;

    public String globalInfo() {
        return "Generator for X/Y plots (with X optional) that attaches error information for Y and optionally X as well. If only one error column is defined, this is interpreted as 'error-delta'; providing two columns is interpreted as 'low' and 'high'.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("y-column", "YColumn", (Object)new SpreadSheetColumnIndex());
        this.m_OptionManager.add("x-column", "XColumn", (Object)new SpreadSheetColumnIndex());
        this.m_OptionManager.add("y-error-columns", "YErrorColumns", (Object)new SpreadSheetColumnRange());
        this.m_OptionManager.add("x-error-columns", "XErrorColumns", (Object)new SpreadSheetColumnRange());
        this.m_OptionManager.add("meta-data-columns", "metaDataColumns", (Object)"");
    }

    protected void initialize() {
        super.initialize();
        this.m_YColumn = new SpreadSheetColumnIndex();
        this.m_XColumn = new SpreadSheetColumnIndex();
        this.m_YErrorColumns = new SpreadSheetColumnRange();
        this.m_XErrorColumns = new SpreadSheetColumnRange();
        this.m_MetaDataColumns = new SpreadSheetColumnRange();
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"YColumn", (Object)((Object)this.getYColumn()), (String)"y: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"XColumn", (Object)((Object)this.getXColumn()), (String)", x: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"YErrorColumns", (Object)(this.getYErrorColumns().isEmpty() ? "-none-" : this.getYErrorColumns()), (String)", y error: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"XErrorColumns", (Object)(this.getXErrorColumns().isEmpty() ? "-none-" : this.getXErrorColumns()), (String)", x error: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"metaDataColumns", (Object)(this.getMetaDataColumns().isEmpty() ? "-none-" : this.getMetaDataColumns()), (String)", meta-data: ");
        return result;
    }

    public void setYColumn(SpreadSheetColumnIndex value) {
        this.m_YColumn = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getYColumn() {
        return this.m_YColumn;
    }

    public String YColumnTipText() {
        return "The column to use for Y; " + this.m_YColumn.getExample();
    }

    public void setXColumn(SpreadSheetColumnIndex value) {
        this.m_XColumn = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getXColumn() {
        return this.m_XColumn;
    }

    public String XColumnTipText() {
        return "The (optional) index of the column which values to use as X values in the plot; " + this.m_XColumn.getExample();
    }

    public void setYErrorColumns(SpreadSheetColumnRange value) {
        this.m_YErrorColumns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getYErrorColumns() {
        return this.m_YErrorColumns;
    }

    public String YErrorColumnsTipText() {
        return "The range of columns to use for Y error information (1=delta, 2=low/high); " + this.m_YErrorColumns.getExample();
    }

    public void setXErrorColumns(SpreadSheetColumnRange value) {
        this.m_XErrorColumns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getXErrorColumns() {
        return this.m_XErrorColumns;
    }

    public String XErrorColumnsTipText() {
        return "The (optional) range of columns to use for X error information (1=delta, 2=low/high); " + this.m_XErrorColumns.getExample();
    }

    public void setMetaDataColumns(String value) {
        this.m_MetaDataColumns.setRange(value);
        this.reset();
    }

    public String getMetaDataColumns() {
        return this.m_MetaDataColumns.getRange();
    }

    public String metaDataColumnsTipText() {
        return "The range of columns to add as meta-data in the plot; " + this.m_MetaDataColumns.getExample();
    }

    @Override
    protected void check(SpreadSheet sheet) {
        super.check(sheet);
        this.m_YColumn.setSpreadSheet(sheet);
        if (this.m_YColumn.getIntIndex() == -1) {
            throw new IllegalStateException("No Y column defined/available?");
        }
        this.m_XColumn.setSpreadSheet(sheet);
        if (this.m_XColumn.getIntIndex() == -1) {
            throw new IllegalStateException("No X column defined/available?");
        }
        this.m_YErrorColumns.setSpreadSheet(sheet);
        int[] cols = this.m_YErrorColumns.getIntIndices();
        if (cols.length > 2) {
            throw new IllegalStateException("Only max. 2 columns can be used for the Y error!");
        }
        this.m_XErrorColumns.setSpreadSheet(sheet);
        cols = this.m_XErrorColumns.getIntIndices();
        if (cols.length > 2) {
            throw new IllegalStateException("Only max. 2 columns can be used for the X error!");
        }
        this.m_MetaDataColumns.setSpreadSheet(sheet);
    }

    @Override
    protected List<SequencePlotterContainer> doGenerate(SpreadSheet sheet) {
        ArrayList<SequencePlotterContainer> result = new ArrayList<SequencePlotterContainer>();
        int[] yErrCols = this.m_YErrorColumns.getIntIndices();
        int[] xErrCols = this.m_XErrorColumns.getIntIndices();
        int yCol = this.m_YColumn.getIntIndex();
        int xCol = this.m_XColumn.getIntIndex();
        int[] metaCols = this.m_MetaDataColumns.getIntIndices();
        String plotName = sheet.getHeaderRow().getCell(yCol).getContent();
        for (int i = 0; i < sheet.getRowCount(); ++i) {
            int n;
            DataRow row = sheet.getRow(i);
            Double[] errX = null;
            Double[] errY = null;
            Comparable<Integer> x = xCol == -1 ? Integer.valueOf(i + 1) : this.getCellValue((Row)row, xCol);
            Comparable y = this.getCellValue((Row)row, yCol);
            if (xErrCols.length > 0) {
                errX = new Double[xErrCols.length];
                for (n = 0; n < xErrCols.length; ++n) {
                    errX[n] = (Double)this.getCellValue((Row)row, xErrCols[n]);
                }
            }
            if (yErrCols.length > 0) {
                errY = new Double[yErrCols.length];
                for (n = 0; n < yErrCols.length; ++n) {
                    errY[n] = (Double)this.getCellValue((Row)row, yErrCols[n]);
                }
            }
            SequencePlotterContainer cont = new SequencePlotterContainer(plotName, (Comparable)x, y, errX, errY, SequencePlotterContainer.ContentType.PLOT);
            for (int m = 0; m < metaCols.length; ++m) {
                cont.addMetaData(sheet.getColumnName(metaCols[m]), this.getCellObject((Row)row, metaCols[m], null));
            }
            result.add(cont);
        }
        return result;
    }
}

