/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.CleanUpHandler;
import adams.core.Properties;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.data.conversion.AbstractSpreadSheetConversion;
import adams.data.conversion.Conversion;
import adams.data.conversion.TransposeSpreadSheet;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.MultiSheetSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.columnfinder.ByName;
import adams.data.spreadsheet.columnfinder.ColumnFinder;
import adams.data.spreadsheet.rowfinder.ByValue;
import adams.data.spreadsheet.rowfinder.RowFinder;
import adams.env.Environment;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.transformer.AbstractSpreadSheetTransformer;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.Convert;
import adams.flow.transformer.SpreadSheetColumnFilter;
import adams.flow.transformer.SpreadSheetDifference;
import adams.flow.transformer.SpreadSheetRowFilter;
import adams.flow.transformer.SpreadSheetSubset;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.ParameterPanel;
import adams.gui.core.RecentFilesHandlerWithCommandline;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.dialog.TextDialog;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.event.SortSetupEvent;
import adams.gui.event.SortSetupListener;
import adams.gui.event.TabVisibilityChangeEvent;
import adams.gui.event.TabVisibilityChangeListener;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import adams.gui.tools.spreadsheetviewer.AbstractDataPlugin;
import adams.gui.tools.spreadsheetviewer.AbstractViewPlugin;
import adams.gui.tools.spreadsheetviewer.SortPanel;
import adams.gui.tools.spreadsheetviewer.SpreadSheetPanel;
import adams.gui.tools.spreadsheetviewer.TabbedPane;
import adams.gui.tools.spreadsheetviewer.chart.AbstractChartGenerator;
import adams.gui.tools.spreadsheetviewer.chart.ScatterPlot;
import adams.gui.tools.spreadsheetviewer.tab.ViewerTabManager;
import adams.parser.SpreadSheetFormula;
import adams.parser.SpreadSheetQuery;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;

public class SpreadSheetViewerPanel
extends BasePanel
implements MenuBarProvider,
SendToActionSupporter,
CleanUpHandler {
    private static final long serialVersionUID = -7759194648757624838L;
    public static final String FILENAME = "SpreadSheetViewer.props";
    public static final String SESSION_FILE = "SpreadSheetViewerSession.props";
    protected static Properties m_Properties;
    protected BaseSplitPane m_SplitPane;
    protected TabbedPane m_TabbedPane;
    protected ViewerTabManager m_ViewerTabs;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemFileOpen;
    protected JMenu m_MenuItemFileOpenRecent;
    protected JMenuItem m_MenuItemFileSaveAs;
    protected JMenuItem m_MenuItemFileClose;
    protected JMenuItem m_MenuItemFileExit;
    protected JMenuItem m_MenuItemDataFilterColumns;
    protected JMenuItem m_MenuItemDataFilterRows;
    protected JMenuItem m_MenuItemDataComputeDifference;
    protected JMenuItem m_MenuItemDataConvert;
    protected JMenuItem m_MenuItemDataTransform;
    protected JMenuItem m_MenuItemDataSort;
    protected JMenuItem m_MenuItemDataChart;
    protected JCheckBoxMenuItem m_MenuItemViewApplyToAll;
    protected JMenuItem m_MenuItemViewDisplayedDecimals;
    protected JMenuItem m_MenuItemViewNegativeBackground;
    protected JMenuItem m_MenuItemViewPositiveBackground;
    protected JMenuItem m_MenuItemViewShowFormulas;
    protected List<JMenuItem> m_MenuItemDataPlugins;
    protected List<AbstractDataPlugin> m_DataPlugins;
    protected List<JMenuItem> m_MenuItemViewPlugins;
    protected List<AbstractViewPlugin> m_ViewPlugins;
    protected SpreadSheetFileChooser m_FileChooser;
    protected RecentFilesHandlerWithCommandline<JMenu> m_RecentFilesHandler;
    protected GenericObjectEditorDialog m_GOEColumnFinder;
    protected GenericObjectEditorDialog m_GOERowFinder;
    protected GenericObjectEditorDialog m_GOEConversion;
    protected GenericObjectEditorDialog m_GOETransformer;
    protected GenericObjectEditorDialog m_GOEChart;
    protected SortPanel m_SortPanel;

    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new SpreadSheetFileChooser();
        this.m_FileChooser.setMultiSelectionEnabled(true);
        this.m_RecentFilesHandler = null;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_SplitPane = new BaseSplitPane(1, true);
        this.m_SplitPane.setOneTouchExpandable(true);
        this.m_SplitPane.setResizeWeight(1.0);
        this.add((Component)this.m_SplitPane, "Center");
        this.m_TabbedPane = new TabbedPane(this);
        this.m_TabbedPane.setCloseTabsWithMiddelMouseButton(true);
        this.m_SplitPane.setLeftComponent((Component)((Object)this.m_TabbedPane));
        this.m_ViewerTabs = new ViewerTabManager(this);
        this.m_ViewerTabs.addTabVisibilityChangeListener(new TabVisibilityChangeListener(){

            public void tabVisibilityChanged(TabVisibilityChangeEvent e) {
                SpreadSheetViewerPanel.this.m_SplitPane.setRightComponentHidden(SpreadSheetViewerPanel.this.m_ViewerTabs.getTabCount() == 0);
            }
        });
        this.m_SplitPane.setRightComponent((Component)((Object)this.m_ViewerTabs));
        this.m_SplitPane.setRightComponentHidden(this.m_ViewerTabs.getTabCount() == 0);
        this.m_SplitPane.setDividerLocation(0.8);
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SpreadSheetViewerPanel.this.updateMenu();
                }
            });
            JMenuItem menuitem = new JMenuItem("Open...");
            menu.add(menuitem);
            menuitem.setMnemonic('O');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed O"));
            menuitem.setIcon(GUIHelper.getIcon((String)"open.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.open();
                }
            });
            this.m_MenuItemFileOpen = menuitem;
            JMenu submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandler = new RecentFilesHandlerWithCommandline(SESSION_FILE, SpreadSheetViewerPanel.getProperties().getInteger("MaxRecentFiles", Integer.valueOf(5)).intValue(), (Object)submenu);
            this.m_RecentFilesHandler.addRecentItemListener((RecentItemListener)new RecentItemListener<JMenu, RecentFilesHandlerWithCommandline.Setup>(){

                public void recentItemAdded(RecentItemEvent<JMenu, RecentFilesHandlerWithCommandline.Setup> e) {
                }

                public void recentItemSelected(RecentItemEvent<JMenu, RecentFilesHandlerWithCommandline.Setup> e) {
                    SpreadSheetViewerPanel.this.load((SpreadSheetReader)((RecentFilesHandlerWithCommandline.Setup)e.getItem()).getHandler(), ((RecentFilesHandlerWithCommandline.Setup)e.getItem()).getFile());
                }
            });
            this.m_MenuItemFileOpenRecent = submenu;
            menuitem = new JMenuItem("Save as...");
            menu.add(menuitem);
            menuitem.setMnemonic('S');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl shift pressed S"));
            menuitem.setIcon(GUIHelper.getIcon((String)"save.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.saveAs();
                }
            });
            this.m_MenuItemFileSaveAs = menuitem;
            menuitem = new JMenuItem("Close tab");
            menu.add(menuitem);
            menuitem.setMnemonic('t');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed W"));
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.closeFile();
                }
            });
            this.m_MenuItemFileClose = menuitem;
            menu.addSeparator();
            if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, (JMenu)menu)) {
                menu.addSeparator();
            }
            menuitem = new JMenuItem("Close");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon((String)"exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.close();
                }
            });
            this.m_MenuItemFileExit = menuitem;
            menu = new JMenu("Data");
            result.add(menu);
            menu.setMnemonic('D');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SpreadSheetViewerPanel.this.updateMenu();
                }
            });
            menuitem = new JMenuItem("Filter columns...");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setIcon(GUIHelper.getIcon((String)"filter_columns.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.findColumns();
                }
            });
            this.m_MenuItemDataFilterColumns = menuitem;
            menuitem = new JMenuItem("Filter rows...");
            menu.add(menuitem);
            menuitem.setMnemonic('R');
            menuitem.setIcon(GUIHelper.getIcon((String)"filter_rows.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.findRows();
                }
            });
            this.m_MenuItemDataFilterRows = menuitem;
            menuitem = new JMenuItem("Convert...");
            menu.add(menuitem);
            menuitem.setMnemonic('v');
            menuitem.setIcon(GUIHelper.getIcon((String)"convert_sheet.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.convert();
                }
            });
            this.m_MenuItemDataConvert = menuitem;
            menuitem = new JMenuItem("Transform...");
            menu.add(menuitem);
            menuitem.setMnemonic('T');
            menuitem.setIcon(GUIHelper.getIcon((String)"flow.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.transform();
                }
            });
            this.m_MenuItemDataTransform = menuitem;
            menuitem = new JMenuItem("Sort...");
            menu.add(menuitem);
            menuitem.setMnemonic('S');
            menuitem.setIcon(GUIHelper.getIcon((String)"sort-ascending.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.sort();
                }
            });
            this.m_MenuItemDataSort = menuitem;
            menuitem = new JMenuItem("Chart...");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setIcon(GUIHelper.getIcon((String)"chart.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.generateChart();
                }
            });
            this.m_MenuItemDataChart = menuitem;
            menuitem = new JMenuItem("Compute difference...");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setIcon(GUIHelper.getIcon((String)"diff.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.computeDifference();
                }
            });
            this.m_MenuItemDataComputeDifference = menuitem;
            String[] classes = AbstractDataPlugin.getPlugins();
            if (classes.length > 0) {
                menu.addSeparator();
                this.m_MenuItemDataPlugins = new ArrayList<JMenuItem>();
                this.m_DataPlugins = new ArrayList<AbstractDataPlugin>();
                for (String cls : classes) {
                    try {
                        final AbstractDataPlugin data = (AbstractDataPlugin)((Object)Class.forName(cls).newInstance());
                        this.m_DataPlugins.add(data);
                        menuitem = data.getMenuIcon() == null ? new JMenuItem(data.getMenuText(), GUIHelper.getEmptyIcon()) : new JMenuItem(data.getMenuText(), GUIHelper.getIcon((String)data.getMenuIcon()));
                        menuitem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                SpreadSheetViewerPanel.this.process(data);
                            }
                        });
                        this.m_MenuItemDataPlugins.add(menuitem);
                        menu.add(menuitem);
                    }
                    catch (Exception e) {
                        System.err.println("Failed to generate menu item for data plugin: " + cls);
                        e.printStackTrace();
                    }
                }
            }
            menu = new JMenu("View");
            result.add(menu);
            menu.setMnemonic('V');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SpreadSheetViewerPanel.this.updateMenu();
                }
            });
            menuitem = new JCheckBoxMenuItem("Apply to all");
            menu.add(menuitem);
            menuitem.setMnemonic('a');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            this.m_MenuItemViewApplyToAll = (JCheckBoxMenuItem)menuitem;
            menuitem = new JMenuItem("Decimals...");
            menu.add(menuitem);
            menuitem.setMnemonic('d');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed D"));
            menuitem.setIcon(GUIHelper.getIcon((String)"decimal-place.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.enterNumDecimals(SpreadSheetViewerPanel.this.m_MenuItemViewApplyToAll.isSelected());
                }
            });
            this.m_MenuItemViewDisplayedDecimals = menuitem;
            menuitem = new JMenuItem("Negative background...");
            menu.add(menuitem);
            menuitem.setMnemonic('n');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.selectBackground(true, SpreadSheetViewerPanel.this.m_MenuItemViewApplyToAll.isSelected());
                }
            });
            this.m_MenuItemViewNegativeBackground = menuitem;
            menuitem = new JMenuItem("Positive background...");
            menu.add(menuitem);
            menuitem.setMnemonic('p');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.selectBackground(false, SpreadSheetViewerPanel.this.m_MenuItemViewApplyToAll.isSelected());
                }
            });
            this.m_MenuItemViewPositiveBackground = menuitem;
            menuitem = new JCheckBoxMenuItem("Show formulas");
            menu.add(menuitem);
            menuitem.setMnemonic('f');
            menuitem.setIcon(GUIHelper.getIcon((String)"formula.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SpreadSheetViewerPanel.this.m_MenuItemViewApplyToAll.isSelected()) {
                        SpreadSheetViewerPanel.this.m_TabbedPane.setShowFormulas(SpreadSheetViewerPanel.this.m_MenuItemViewShowFormulas.isSelected());
                    } else {
                        SpreadSheetViewerPanel.this.m_TabbedPane.setShowFormulasAt(SpreadSheetViewerPanel.this.m_TabbedPane.getSelectedIndex(), SpreadSheetViewerPanel.this.m_MenuItemViewShowFormulas.isSelected());
                    }
                }
            });
            this.m_MenuItemViewShowFormulas = menuitem;
            this.m_ViewerTabs.addTabsSubmenu(menu);
            classes = AbstractViewPlugin.getPlugins();
            if (classes.length > 0) {
                menu.addSeparator();
                this.m_MenuItemViewPlugins = new ArrayList<JMenuItem>();
                this.m_ViewPlugins = new ArrayList<AbstractViewPlugin>();
                for (String cls : classes) {
                    try {
                        final AbstractViewPlugin view = (AbstractViewPlugin)((Object)Class.forName(cls).newInstance());
                        this.m_ViewPlugins.add(view);
                        menuitem = view.getMenuIcon() == null ? new JMenuItem(view.getMenuText(), GUIHelper.getEmptyIcon()) : new JMenuItem(view.getMenuText(), GUIHelper.getIcon((String)view.getMenuIcon()));
                        menuitem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                SpreadSheetViewerPanel.this.view(view);
                            }
                        });
                        this.m_MenuItemViewPlugins.add(menuitem);
                        menu.add(menuitem);
                    }
                    catch (Exception e) {
                        System.err.println("Failed to generate menu item for view plugin: " + cls);
                        e.printStackTrace();
                    }
                }
            }
            menu = new JMenu("Help");
            result.add(menu);
            menu.setMnemonic('H');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SpreadSheetViewerPanel.this.updateMenu();
                }
            });
            menuitem = new JMenuItem("Formulas");
            menu.add(menuitem);
            menuitem.setMnemonic('F');
            menuitem.setIcon(GUIHelper.getIcon((String)"formula.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.showHelpText("Formulas", new SpreadSheetFormula().getGrammar());
                }
            });
            menuitem = new JMenuItem("Query");
            menu.add(menuitem);
            menuitem.setMnemonic('Q');
            menuitem.setIcon(GUIHelper.getIcon((String)"query.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.showHelpText("Query", new SpreadSheetQuery().getGrammar());
                }
            });
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    public TabbedPane getTabbedPane() {
        return this.m_TabbedPane;
    }

    public ViewerTabManager getViewerTabs() {
        return this.m_ViewerTabs;
    }

    protected void showHelpText(String title, String content) {
        TextDialog dialog = this.getParentDialog() != null ? new TextDialog(this.getParentDialog()) : new TextDialog(this.getParentFrame());
        dialog.setDialogTitle(title);
        dialog.setContent(content);
        dialog.setEditable(false);
        dialog.setSize(800, 600);
        GUIHelper.setSizeAndLocation((Window)dialog);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
    }

    protected void enterNumDecimals(boolean applyAll) {
        int decimals = applyAll ? -1 : this.m_TabbedPane.getNumDecimalsAt(this.m_TabbedPane.getSelectedIndex());
        String valueStr = JOptionPane.showInputDialog("Please enter the number of decimals to display (-1 to display all):", (Object)decimals);
        if (valueStr == null) {
            return;
        }
        decimals = Integer.parseInt(valueStr);
        if (applyAll) {
            this.m_TabbedPane.setNumDecimals(decimals);
        } else {
            this.m_TabbedPane.setNumDecimalsAt(this.m_TabbedPane.getSelectedIndex(), decimals);
        }
    }

    protected void selectBackground(boolean negative, boolean applyAll) {
        Color color = applyAll ? Color.WHITE : (negative ? this.m_TabbedPane.getNegativeBackgroundAt(this.m_TabbedPane.getSelectedIndex()) : this.m_TabbedPane.getPositiveBackgroundAt(this.m_TabbedPane.getSelectedIndex()));
        color = negative ? JColorChooser.showDialog((Component)((Object)this), "Background for negative values", color) : JColorChooser.showDialog((Component)((Object)this), "Background for positive values", color);
        if (color == null) {
            return;
        }
        if (negative) {
            if (applyAll) {
                this.m_TabbedPane.setNegativeBackground(color);
            } else {
                this.m_TabbedPane.setNegativeBackgroundAt(this.m_TabbedPane.getSelectedIndex(), color);
            }
        } else if (applyAll) {
            this.m_TabbedPane.setPositiveBackground(color);
        } else {
            this.m_TabbedPane.setPositiveBackgroundAt(this.m_TabbedPane.getSelectedIndex(), color);
        }
    }

    protected void updateMenu() {
        int i;
        if (this.m_MenuBar == null) {
            return;
        }
        boolean sheetSelected = this.m_TabbedPane.getTabCount() > 0 && this.m_TabbedPane.getSelectedIndex() != -1;
        SpreadSheetPanel panel = this.m_TabbedPane.getCurrentPanel();
        this.m_MenuItemFileSaveAs.setEnabled(sheetSelected);
        this.m_MenuItemFileClose.setEnabled(sheetSelected);
        this.m_MenuItemDataFilterColumns.setEnabled(sheetSelected);
        this.m_MenuItemDataFilterRows.setEnabled(sheetSelected);
        this.m_MenuItemDataConvert.setEnabled(sheetSelected);
        this.m_MenuItemDataTransform.setEnabled(sheetSelected);
        this.m_MenuItemDataSort.setEnabled(sheetSelected);
        this.m_MenuItemDataChart.setEnabled(sheetSelected);
        this.m_MenuItemDataComputeDifference.setEnabled(this.m_TabbedPane.getTabCount() >= 2);
        if (this.m_MenuItemDataPlugins != null) {
            for (i = 0; i < this.m_DataPlugins.size(); ++i) {
                this.m_MenuItemDataPlugins.get(i).setEnabled(sheetSelected && this.m_DataPlugins.get(i).canProcess(panel));
            }
        }
        this.m_MenuItemViewDisplayedDecimals.setEnabled(this.m_TabbedPane.getTabCount() > 0);
        this.m_MenuItemViewNegativeBackground.setEnabled(this.m_TabbedPane.getTabCount() > 0);
        this.m_MenuItemViewPositiveBackground.setEnabled(this.m_TabbedPane.getTabCount() > 0);
        this.m_MenuItemViewShowFormulas.setEnabled(this.m_TabbedPane.getTabCount() > 0);
        if (this.m_MenuItemViewPlugins != null) {
            for (i = 0; i < this.m_ViewPlugins.size(); ++i) {
                this.m_MenuItemViewPlugins.get(i).setEnabled(sheetSelected && this.m_ViewPlugins.get(i).canView(panel));
            }
        }
    }

    protected void open() {
        PlaceholderFile[] files;
        int retVal = this.m_FileChooser.showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        for (PlaceholderFile file : files = this.m_FileChooser.getSelectedPlaceholderFiles()) {
            this.load((SpreadSheetReader)this.m_FileChooser.getReader(), (File)file);
        }
    }

    public void load(File file) {
        this.load(this.m_FileChooser.getReaderForFile(file), file);
    }

    public void load(SpreadSheetReader reader, File file) {
        if (reader == null) {
            reader = new CsvSpreadSheetReader();
        }
        SpreadSheet sheet = null;
        List sheets = null;
        if (reader instanceof MultiSheetSpreadSheetReader) {
            sheets = ((MultiSheetSpreadSheetReader)reader).readRange(file.getAbsolutePath());
        } else {
            sheet = reader.read(file.getAbsolutePath());
        }
        if (sheet == null && sheets == null) {
            String msg = reader.hasLastError() ? "Error loading spreadsheet file:\n" + file + "\n" + reader.getLastError() : "Error loading spreadsheet file:\n" + file;
            GUIHelper.showErrorMessage((Component)((Object)this), (String)msg);
        } else {
            if (sheet != null) {
                this.m_TabbedPane.addTab(file, sheet);
            } else {
                for (SpreadSheet sh : sheets) {
                    this.m_TabbedPane.addTab(file, sh);
                }
            }
            this.m_FileChooser.setCurrentDirectory(file.getParentFile());
            if (this.m_RecentFilesHandler != null) {
                this.m_RecentFilesHandler.addRecentItem((Object)new RecentFilesHandlerWithCommandline.Setup(file, (Object)reader));
            }
        }
    }

    public void write(SpreadSheetWriter writer, File file) {
        SpreadSheetTable table = this.m_TabbedPane.getCurrentTable();
        if (table == null) {
            return;
        }
        if (!writer.write(table.toSpreadSheet(), file)) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to write spreadsheet to '" + file + "'!"));
        }
    }

    protected void saveAs() {
        int retVal = this.m_FileChooser.showSaveDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        PlaceholderFile file = this.m_FileChooser.getSelectedPlaceholderFile();
        this.write((SpreadSheetWriter)this.m_FileChooser.getWriter(), (File)file);
    }

    protected void closeFile() {
        int index = this.m_TabbedPane.getSelectedIndex();
        if (index == -1) {
            return;
        }
        this.m_TabbedPane.remove(index);
    }

    protected void close() {
        this.closeParent();
    }

    public SpreadSheetPanel[] getAllPanels() {
        return this.m_TabbedPane.getAllPanels();
    }

    public SpreadSheetPanel getCurrentPanel() {
        return this.m_TabbedPane.getCurrentPanel();
    }

    public Class[] getSendToClasses() {
        return new Class[]{PlaceholderFile.class, JTable.class};
    }

    public boolean hasSendToItem(Class[] cls) {
        return SendToActionUtils.isAvailable((Class[])new Class[]{PlaceholderFile.class, JTable.class}, (Class[])cls) && this.m_TabbedPane.getSelectedIndex() != -1;
    }

    public Object getSendToItem(Class[] cls) {
        int index = this.m_TabbedPane.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        SpreadSheetTable result = null;
        if (SendToActionUtils.isAvailable(PlaceholderFile.class, (Class[])cls)) {
            CsvSpreadSheetWriter writer = new CsvSpreadSheetWriter();
            SpreadSheet sheet = this.m_TabbedPane.getTableAt(index).toSpreadSheet();
            if (!writer.write(sheet, (File)((PlaceholderFile)(result = SendToActionUtils.nextTmpFile((String)"spreadsheetviewer", (String)"csv"))))) {
                result = null;
            }
        } else if (SendToActionUtils.isAvailable(JTable.class, (Class[])cls)) {
            result = this.m_TabbedPane.getTableAt(index);
        }
        return result;
    }

    protected GenericObjectEditorDialog getColumnFinderDialog() {
        if (this.m_GOEColumnFinder == null) {
            this.m_GOEColumnFinder = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
            this.m_GOEColumnFinder.setTitle("Column finder");
            this.m_GOEColumnFinder.getGOEEditor().setClassType(ColumnFinder.class);
            this.m_GOEColumnFinder.getGOEEditor().setCanChangeClassInDialog(true);
            this.m_GOEColumnFinder.getGOEEditor().setValue((Object)new ByName());
            this.m_GOEColumnFinder.setLocationRelativeTo((Component)((Object)this));
        }
        return this.m_GOEColumnFinder;
    }

    protected GenericObjectEditorDialog getRowFinderDialog() {
        if (this.m_GOERowFinder == null) {
            this.m_GOERowFinder = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
            this.m_GOERowFinder.setTitle("Row finder");
            this.m_GOERowFinder.getGOEEditor().setClassType(RowFinder.class);
            this.m_GOERowFinder.getGOEEditor().setCanChangeClassInDialog(true);
            this.m_GOERowFinder.getGOEEditor().setValue((Object)new ByValue());
            this.m_GOERowFinder.setLocationRelativeTo((Component)((Object)this));
        }
        return this.m_GOERowFinder;
    }

    protected GenericObjectEditorDialog getConversionDialog() {
        if (this.m_GOEConversion == null) {
            this.m_GOEConversion = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
            this.m_GOEConversion.setTitle("Conversion");
            this.m_GOEConversion.getGOEEditor().setClassType(AbstractSpreadSheetConversion.class);
            this.m_GOEConversion.getGOEEditor().setCanChangeClassInDialog(true);
            this.m_GOEConversion.getGOEEditor().setValue((Object)new TransposeSpreadSheet());
            this.m_GOEConversion.setLocationRelativeTo((Component)((Object)this));
        }
        return this.m_GOEConversion;
    }

    protected GenericObjectEditorDialog getTransformerDialog() {
        if (this.m_GOETransformer == null) {
            this.m_GOETransformer = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
            this.m_GOETransformer.setTitle("Transformer");
            this.m_GOETransformer.getGOEEditor().setClassType(AbstractSpreadSheetTransformer.class);
            this.m_GOETransformer.getGOEEditor().setCanChangeClassInDialog(true);
            this.m_GOETransformer.getGOEEditor().setValue((Object)new SpreadSheetSubset());
            this.m_GOETransformer.setLocationRelativeTo((Component)((Object)this));
        }
        return this.m_GOETransformer;
    }

    protected GenericObjectEditorDialog getChartGeneratorDialog() {
        if (this.m_GOEChart == null) {
            this.m_GOEChart = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
            this.m_GOEChart.setTitle("Chart");
            this.m_GOEChart.getGOEEditor().setClassType(AbstractChartGenerator.class);
            this.m_GOEChart.getGOEEditor().setCanChangeClassInDialog(true);
            this.m_GOEChart.getGOEEditor().setValue((Object)new ScatterPlot());
            this.m_GOEChart.setLocationRelativeTo((Component)((Object)this));
        }
        return this.m_GOEChart;
    }

    protected void filterData(String oldTitle, Object input, AbstractActor filter) {
        try {
            List processed = ActorUtils.transform((AbstractActor)filter, (Object)input);
            for (Object obj : processed) {
                if (!(obj instanceof SpreadSheet)) {
                    GUIHelper.showErrorMessage((Component)((Object)this), (String)("Generated non-spreadsheet object??\n" + obj.getClass().getName()));
                    return;
                }
                this.m_TabbedPane.addTab(oldTitle + "'", (SpreadSheet)obj);
            }
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to filter data:\n" + Utils.throwableToString((Throwable)e)));
        }
    }

    protected void findColumns() {
        SpreadSheet sheet = this.m_TabbedPane.getCurrentSheet();
        if (sheet == null) {
            return;
        }
        this.getColumnFinderDialog().setVisible(true);
        if (this.getColumnFinderDialog().getResult() != 0) {
            return;
        }
        ColumnFinder finder = (ColumnFinder)this.getColumnFinderDialog().getGOEEditor().getValue();
        SpreadSheetColumnFilter filter = new SpreadSheetColumnFilter();
        filter.setFinder(finder);
        this.filterData(this.m_TabbedPane.getTitleAt(this.m_TabbedPane.getSelectedIndex()), sheet, (AbstractActor)filter);
    }

    protected void findRows() {
        SpreadSheet sheet = this.m_TabbedPane.getCurrentSheet();
        if (sheet == null) {
            return;
        }
        this.getRowFinderDialog().setVisible(true);
        if (this.getRowFinderDialog().getResult() != 0) {
            return;
        }
        RowFinder finder = (RowFinder)this.getRowFinderDialog().getGOEEditor().getValue();
        SpreadSheetRowFilter filter = new SpreadSheetRowFilter();
        filter.setFinder(finder);
        this.filterData(this.m_TabbedPane.getTitleAt(this.m_TabbedPane.getSelectedIndex()), sheet, (AbstractActor)filter);
    }

    protected void convert() {
        SpreadSheet sheet = this.m_TabbedPane.getCurrentSheet();
        if (sheet == null) {
            return;
        }
        this.getConversionDialog().setVisible(true);
        if (this.getConversionDialog().getResult() != 0) {
            return;
        }
        Conversion conversion = (Conversion)this.getConversionDialog().getGOEEditor().getValue();
        Convert filter = new Convert();
        filter.setConversion(conversion);
        this.filterData(this.m_TabbedPane.getTitleAt(this.m_TabbedPane.getSelectedIndex()), sheet, (AbstractActor)filter);
    }

    protected void transform() {
        SpreadSheet sheet = this.m_TabbedPane.getCurrentSheet();
        if (sheet == null) {
            return;
        }
        this.getTransformerDialog().setVisible(true);
        if (this.getTransformerDialog().getResult() != 0) {
            return;
        }
        AbstractTransformer transformer = (AbstractTransformer)this.getTransformerDialog().getGOEEditor().getValue();
        this.filterData(this.m_TabbedPane.getTitleAt(this.m_TabbedPane.getSelectedIndex()), sheet, (AbstractActor)transformer);
    }

    protected void computeDifference(SpreadSheet sheet1, SpreadSheet sheet2, SpreadSheetColumnRange keyCols) {
        if (sheet1 == null || sheet2 == null) {
            return;
        }
        SpreadSheetDifference filter = new SpreadSheetDifference();
        filter.setKeyColumns(keyCols);
        this.filterData(this.m_TabbedPane.newTitle(), new SpreadSheet[]{sheet1, sheet2}, (AbstractActor)filter);
    }

    protected void sort() {
        final ApprovalDialog dialog = this.getParentDialog() != null ? new ApprovalDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new ApprovalDialog(this.getParentFrame(), true);
        dialog.setDefaultCloseOperation(2);
        dialog.setTitle("Sort");
        dialog.getApproveButton().setEnabled(false);
        if (this.m_SortPanel == null) {
            this.m_SortPanel = new SortPanel();
            this.m_SortPanel.addSortSetupListener(new SortSetupListener(){

                @Override
                public void sortSetupChanged(SortSetupEvent e) {
                    dialog.getApproveButton().setEnabled(e.getSortPanel().isValidSetup());
                }
            });
        }
        if (this.m_SortPanel.setSpreadSheet(this.m_TabbedPane.getCurrentSheet())) {
            this.m_SortPanel.addDefinition();
        }
        dialog.getApproveButton().setEnabled(this.m_SortPanel.isValidSetup());
        dialog.getContentPane().add((Component)((Object)this.m_SortPanel), "Center");
        dialog.pack();
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.getOption() != 0) {
            return;
        }
        this.m_TabbedPane.getCurrentTable().sort(this.m_SortPanel.getComparator());
    }

    protected void generateChart() {
        SpreadSheetPanel panel = this.m_TabbedPane.getCurrentPanel();
        if (panel == null) {
            return;
        }
        this.getChartGeneratorDialog().setVisible(true);
        if (this.getChartGeneratorDialog().getResult() != 0) {
            return;
        }
        AbstractChartGenerator generator = (AbstractChartGenerator)((Object)this.getChartGeneratorDialog().getGOEEditor().getValue());
        panel.generateChart(generator);
    }

    protected void computeDifference() {
        ApprovalDialog dialog = this.getParentDialog() != null ? new ApprovalDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new ApprovalDialog(this.getParentFrame(), true);
        dialog.setTitle("Compute difference");
        ParameterPanel params = new ParameterPanel();
        dialog.getContentPane().add((Component)params, "Center");
        List<String> titles = this.m_TabbedPane.getTabTitles();
        JComboBox<String> sheet1 = new JComboBox<String>(titles.toArray(new String[titles.size()]));
        params.addParameter("First sheet", sheet1);
        params.addParameter("", (Component)new JLabel("minus"));
        JComboBox<String> sheet2 = new JComboBox<String>(titles.toArray(new String[titles.size()]));
        params.addParameter("Second sheet", sheet2);
        params.addParameter("", (Component)new JLabel("using"));
        JTextField range = new JTextField(10);
        range.setText("");
        range.setToolTipText(new SpreadSheetColumnRange().getExample());
        params.addParameter("Key columns", (Component)range);
        dialog.pack();
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.getOption() != 0) {
            return;
        }
        if (sheet1.getSelectedIndex() == sheet2.getSelectedIndex()) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)"You must select two different spreadsheets!");
            return;
        }
        this.computeDifference(this.m_TabbedPane.getSheetAt(sheet1.getSelectedIndex()), this.m_TabbedPane.getSheetAt(sheet2.getSelectedIndex()), new SpreadSheetColumnRange(range.getText()));
    }

    protected void process(AbstractDataPlugin plugin) {
        SpreadSheetPanel panel = this.m_TabbedPane.getCurrentPanel();
        if (panel == null) {
            return;
        }
        SpreadSheet input = panel.getSheet();
        if (input == null) {
            return;
        }
        plugin.setCurrentPanel(panel);
        SpreadSheet output = plugin.process(input);
        if (plugin.getCanceledByUser() || output == null) {
            return;
        }
        if (plugin.isInPlace()) {
            this.m_TabbedPane.getCurrentTable().setModel((TableModel)new SpreadSheetTableModel(output));
        } else {
            this.m_TabbedPane.addTab(this.m_TabbedPane.newTitle(), output);
        }
        plugin.setCurrentPanel(null);
    }

    protected void view(AbstractViewPlugin plugin) {
        SpreadSheetPanel current = this.m_TabbedPane.getCurrentPanel();
        if (current == null || current.getSheet() == null) {
            return;
        }
        SpreadSheet sheet = current.getSheet();
        plugin.setCurrentPanel(current);
        BasePanel panel = plugin.generate(sheet);
        plugin.setCurrentPanel(null);
        if (plugin.getCanceledByUser() || panel == null) {
            return;
        }
        ApprovalDialog dialog = this.getParentDialog() != null ? new ApprovalDialog(this.getParentDialog(), Dialog.ModalityType.MODELESS) : new ApprovalDialog(this.getParentFrame(), false);
        String title = plugin.getMenuText();
        if (current.getTabTitle() != null) {
            title = title + " - " + current.getTabTitle();
        }
        dialog.setTitle(title);
        if (plugin.getMenuIcon() != null) {
            dialog.setIconImage(GUIHelper.getIcon((String)plugin.getMenuIcon()).getImage());
        }
        dialog.getContentPane().add((Component)panel, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
    }

    public void cleanUp() {
        if (this.m_GOEChart != null) {
            this.m_GOEChart.dispose();
            this.m_GOEChart = null;
        }
        if (this.m_GOEColumnFinder != null) {
            this.m_GOEColumnFinder.dispose();
            this.m_GOEColumnFinder = null;
        }
        if (this.m_GOEConversion != null) {
            this.m_GOEConversion.dispose();
            this.m_GOEConversion = null;
        }
        if (this.m_GOERowFinder != null) {
            this.m_GOERowFinder.dispose();
            this.m_GOERowFinder = null;
        }
        if (this.m_GOETransformer != null) {
            this.m_GOETransformer.dispose();
            this.m_GOETransformer = null;
        }
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("spreadsheet viewer panel");
        }
        return m_Properties;
    }
}

