/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer;

import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.SpreadSheetTable;
import adams.gui.tools.SpreadSheetViewerPanel;
import adams.gui.tools.spreadsheetviewer.SpreadSheetPanel;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabbedPane
extends BaseTabbedPane {
    private static final long serialVersionUID = -2048229771213837710L;
    public static final String PREFIX_TITLE = "new";
    protected SpreadSheetViewerPanel m_Owner;
    protected int m_NumDecimals;
    protected Color m_BackgroundNegative;
    protected Color m_BackgroundPositive;

    public TabbedPane(SpreadSheetViewerPanel owner) {
        this.setOwner(owner);
        this.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TabbedPane.this.tabSelected(e);
            }
        });
    }

    protected void initialize() {
        super.initialize();
        this.m_NumDecimals = -1;
        this.m_BackgroundNegative = null;
        this.m_BackgroundPositive = null;
    }

    public void setOwner(SpreadSheetViewerPanel value) {
        this.m_Owner = value;
    }

    public SpreadSheetViewerPanel getOwner() {
        return this.m_Owner;
    }

    public int getPanelCount() {
        return this.getTabCount();
    }

    public SpreadSheetPanel[] getAllPanels() {
        SpreadSheetPanel[] result = new SpreadSheetPanel[this.getTabCount()];
        for (int i = 0; i < this.getTabCount(); ++i) {
            result[i] = this.getPanelAt(i);
        }
        return result;
    }

    public SpreadSheetPanel getPanelAt(int index) {
        if (index < 0 || index >= this.getTabCount()) {
            return null;
        }
        SpreadSheetPanel result = (SpreadSheetPanel)((Object)this.getComponentAt(index));
        return result;
    }

    public SpreadSheetTable getTableAt(int index) {
        SpreadSheetTable result = null;
        SpreadSheetPanel panel = this.getPanelAt(index);
        if (panel != null) {
            result = panel.getTable();
        }
        return result;
    }

    public SpreadSheet getSheetAt(int index) {
        SpreadSheet result = null;
        SpreadSheetTable table = this.getTableAt(index);
        if (table == null) {
            return result;
        }
        result = table.toSpreadSheet();
        return result;
    }

    public void setNumDecimalsAt(int index, int numDec) {
        this.getTableAt(index).setNumDecimals(numDec);
    }

    public int getNumDecimalsAt(int index) {
        return this.getTableAt(index).getNumDecimals();
    }

    public void setNumDecimals(int numDec) {
        this.m_NumDecimals = numDec;
        for (int i = 0; i < this.getTabCount(); ++i) {
            this.setNumDecimalsAt(i, numDec);
        }
    }

    public int getNumDecimals() {
        return this.m_NumDecimals;
    }

    public void setNegativeBackgroundAt(int index, Color color) {
        this.getTableAt(index).setNegativeBackground(color);
    }

    public Color getNegativeBackgroundAt(int index) {
        return this.getTableAt(index).getNegativeBackground();
    }

    public void setNegativeBackground(Color color) {
        this.m_BackgroundNegative = color;
        for (int i = 0; i < this.getTabCount(); ++i) {
            this.setNegativeBackgroundAt(i, color);
        }
    }

    public Color getNegativeBackground() {
        return this.m_BackgroundNegative;
    }

    public void setPositiveBackgroundAt(int index, Color color) {
        this.getTableAt(index).setPositiveBackground(color);
    }

    public Color getPositiveBackgroundAt(int index) {
        return this.getTableAt(index).getPositiveBackground();
    }

    public void setPositiveBackground(Color color) {
        this.m_BackgroundPositive = color;
        for (int i = 0; i < this.getTabCount(); ++i) {
            this.setPositiveBackgroundAt(i, color);
        }
    }

    public Color getPositiveBackground() {
        return this.m_BackgroundPositive;
    }

    public void setShowFormulasAt(int index, boolean value) {
        this.getTableAt(index).setShowFormulas(value);
    }

    public boolean getShowFormulas(int index) {
        return this.getTableAt(index).getShowFormulas();
    }

    public void setShowFormulas(boolean value) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            this.setShowFormulasAt(i, value);
        }
    }

    public SpreadSheetPanel getCurrentPanel() {
        return this.getPanelAt(this.getSelectedIndex());
    }

    public SpreadSheetTable getCurrentTable() {
        return this.getTableAt(this.getSelectedIndex());
    }

    public SpreadSheet getCurrentSheet() {
        return this.getSheetAt(this.getSelectedIndex());
    }

    public SpreadSheetPanel addTab(File file, SpreadSheet sheet) {
        return this.addTab(file.getName() + (sheet.getName() != null ? "/" + sheet.getName() : ""), sheet);
    }

    public SpreadSheetPanel addTab(String title, SpreadSheet sheet) {
        SpreadSheetPanel result = new SpreadSheetPanel(this);
        result.setNumDecimals(this.m_NumDecimals);
        result.setNegativeBackground(this.m_BackgroundNegative);
        result.setPositiveBackground(this.m_BackgroundPositive);
        result.setSheet(sheet);
        this.addTab(title, (Component)((Object)result));
        this.setSelectedIndex(this.getTabCount() - 1);
        return result;
    }

    public List<String> getTabTitles() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.getTabCount(); ++i) {
            result.add(this.getTitleAt(i));
        }
        return result;
    }

    public String newTitle() {
        String result;
        HashSet<String> titles = new HashSet<String>(this.getTabTitles());
        int i = 0;
        while (titles.contains(result = PREFIX_TITLE + ++i)) {
        }
        return result;
    }

    protected void tabSelected(ChangeEvent e) {
        if (this.getPanelCount() == 0) {
            this.m_Owner.getViewerTabs().notifyTabs(null, new int[0]);
        } else {
            this.m_Owner.getViewerTabs().notifyTabs(this.m_Owner.getCurrentPanel(), this.m_Owner.getCurrentPanel().getTable().getSelectedRows());
        }
    }
}

