/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer.chart;

import adams.data.DecimalFormatString;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.SequencePlotter;
import adams.flow.sink.sequenceplotter.AbstractPlotUpdater;
import adams.flow.sink.sequenceplotter.SimplePlotUpdater;
import adams.flow.transformer.SpreadSheetPlotGenerator;
import adams.flow.transformer.plotgenerator.XYPlotGenerator;
import adams.gui.tools.spreadsheetviewer.chart.AbstractChartGenerator;
import adams.gui.visualization.core.AbstractColorProvider;
import adams.gui.visualization.core.AxisPanelOptions;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.sequence.CirclePaintlet;
import adams.gui.visualization.sequence.XYSequencePaintlet;

public class ScatterPlot
extends AbstractChartGenerator {
    private static final long serialVersionUID = -2088311829009151566L;
    protected SpreadSheetColumnIndex m_XColumn;
    protected SpreadSheetColumnRange m_YColumns;
    protected AbstractColorProvider m_ColorProvider;

    public String globalInfo() {
        return "Generates a scatter plot by plotting the X column against one or more Y columns.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("x-column", "XColumn", (Object)"");
        this.m_OptionManager.add("y-columns", "YColumns", (Object)"");
        this.m_OptionManager.add("color-provider", "colorProvider", (Object)new DefaultColorProvider());
    }

    protected void initialize() {
        super.initialize();
        this.m_YColumns = new SpreadSheetColumnRange();
        this.m_XColumn = new SpreadSheetColumnIndex();
    }

    @Override
    public String getQuickInfo() {
        String result = "x: ";
        String variable = this.getOptionManager().getVariableForProperty("XColumn");
        result = variable != null ? result + variable : result + this.m_XColumn.getIndex();
        result = result + ", y: ";
        variable = this.getOptionManager().getVariableForProperty("YColumns");
        result = variable != null ? result + variable : result + this.m_YColumns.getRange();
        result = result + ", color: ";
        variable = this.getOptionManager().getVariableForProperty("colorProvider");
        result = variable != null ? result + variable : result + this.m_ColorProvider.getClass().getSimpleName();
        return result;
    }

    public void setXColumn(String value) {
        this.m_XColumn.setIndex(value);
        this.reset();
    }

    public String getXColumn() {
        return this.m_XColumn.getIndex();
    }

    public String XColumnTipText() {
        return "The index of the column which values to use on the X axis; " + this.m_XColumn.getExample();
    }

    public void setYColumns(String value) {
        this.m_YColumns.setRange(value);
        this.reset();
    }

    public String getYColumns() {
        return this.m_YColumns.getRange();
    }

    public String YColumnsTipText() {
        return "The range of columns to use on the Y axis; " + this.m_YColumns.getExample();
    }

    public void setColorProvider(AbstractColorProvider value) {
        this.m_ColorProvider = value;
        this.reset();
    }

    public AbstractColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public String colorProviderTipText() {
        return "The color provider to use.";
    }

    @Override
    protected void addChartGeneration(Flow flow, String name, SpreadSheet sheet) {
        this.m_XColumn.setData(sheet);
        this.m_YColumns.setData(sheet);
        XYPlotGenerator generator = new XYPlotGenerator();
        generator.setXColumn(this.m_XColumn.getIndex());
        generator.setPlotColumns(this.m_YColumns.getRange());
        SpreadSheetPlotGenerator pg = new SpreadSheetPlotGenerator();
        pg.setGenerator(generator);
        flow.add((AbstractActor)pg);
        SimplePlotUpdater updater = new SimplePlotUpdater();
        updater.setUpdateInterval(0);
        SequencePlotter plotter = new SequencePlotter();
        if (name != null) {
            plotter.setName(name);
        } else {
            plotter.setName("Scatter plot");
        }
        plotter.setTitle("Scatter plot");
        plotter.setShortTitle(true);
        plotter.setPaintlet((XYSequencePaintlet)new CirclePaintlet());
        plotter.setColorProvider(this.m_ColorProvider.shallowCopy());
        plotter.setPlotUpdater((AbstractPlotUpdater)updater);
        plotter.setWidth(this.m_Width);
        plotter.setHeight(this.m_Height);
        AxisPanelOptions axis = plotter.getAxisX();
        axis.setLabel("X");
        axis.setNthValueToShow(1);
        axis.setTickGenerator(this.columnTypeToTickGenerator(sheet, this.m_XColumn.getIntIndex()));
        axis.setType(this.columnTypeToAxisType(sheet, this.m_XColumn.getIntIndex()));
        axis.setCustomFormat(new DecimalFormatString("0.0"));
        plotter.setAxisX(axis);
        axis = plotter.getAxisY();
        axis.setLabel("Y");
        axis.setNthValueToShow(1);
        axis.setTickGenerator(this.columnTypesToTickGenerator(sheet, this.m_YColumns.getIntIndices()));
        axis.setType(this.columnTypesToAxisType(sheet, this.m_YColumns.getIntIndices()));
        axis.setCustomFormat(new DecimalFormatString("0.0"));
        plotter.setAxisX(axis);
        flow.add((AbstractActor)plotter);
    }
}

