/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.DateFormat;
import adams.core.DateTime;
import adams.core.DateUtils;
import adams.core.Utils;
import adams.data.io.input.AbstractExcelSpreadSheetReader;
import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelSpreadSheetReader
extends AbstractExcelSpreadSheetReader {
    private static final long serialVersionUID = 4755872204697328246L;

    public String globalInfo() {
        return "Reads MS Excel files (using DOM).";
    }

    public String getFormatDescription() {
        return "MS Excel spreadsheets";
    }

    public String[] getFormatExtensions() {
        return new String[]{"xls", "xlsx"};
    }

    protected AbstractSpreadSheetReader.InputType getInputType() {
        return AbstractSpreadSheetReader.InputType.STREAM;
    }

    protected String numericToString(Cell cell) {
        Double dbl = cell.getNumericCellValue();
        long lng = dbl.longValue();
        if (dbl == (double)lng) {
            return "" + lng;
        }
        return "" + dbl;
    }

    protected List<SpreadSheet> doReadRange(InputStream in) {
        ArrayList<SpreadSheet> result = new ArrayList<SpreadSheet>();
        Workbook workbook = null;
        DateFormat dformat = DateUtils.getTimestampFormatter();
        try {
            int[] indices;
            workbook = WorkbookFactory.create((InputStream)in);
            this.m_SheetRange.setMax(workbook.getNumberOfSheets());
            for (int index : indices = this.m_SheetRange.getIntIndices()) {
                if (!this.m_Stopped) {
                    boolean numeric;
                    Cell exCell;
                    int i;
                    HeaderRow spRow;
                    Row exRow;
                    Sheet sheet;
                    SpreadSheet spsheet = this.m_SpreadSheetType.newInstance();
                    spsheet.setDataRowClass(this.m_DataRowType.getRowClass());
                    result.add(spsheet);
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("sheet: " + (index + 1));
                    }
                    if ((sheet = workbook.getSheetAt(index)).getLastRowNum() == 0) {
                        this.getLogger().severe("No rows in sheet #" + index);
                        return null;
                    }
                    spsheet.setName(sheet.getSheetName());
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("header row");
                    }
                    if ((exRow = sheet.getRow(0)) == null) {
                        this.getLogger().warning("No data in sheet #" + (index + 1) + "?");
                    } else if (exRow != null) {
                        spRow = spsheet.getHeaderRow();
                        this.m_TextColumns.setMax((int)exRow.getLastCellNum());
                        block11: for (i = 0; i < exRow.getLastCellNum() && !this.m_Stopped; ++i) {
                            exCell = exRow.getCell(i);
                            if (exCell == null) {
                                spRow.addCell("" + (i + 1)).setMissing();
                                continue;
                            }
                            numeric = !this.m_TextColumns.isInRange(i);
                            switch (exCell.getCellType()) {
                                case 3: 
                                case 5: {
                                    spRow.addCell("" + (i + 1)).setContent("column-" + (i + 1));
                                    continue block11;
                                }
                                case 0: {
                                    if (HSSFDateUtil.isCellDateFormatted((Cell)exCell)) {
                                        spRow.addCell("" + (i + 1)).setContent(new DateTime(HSSFDateUtil.getJavaDate((double)exCell.getNumericCellValue())));
                                        continue block11;
                                    }
                                    if (numeric) {
                                        spRow.addCell("" + (i + 1)).setContent(Double.valueOf(exCell.getNumericCellValue()));
                                        continue block11;
                                    }
                                    spRow.addCell("" + (i + 1)).setContentAsString(this.numericToString(exCell));
                                    continue block11;
                                }
                                default: {
                                    spRow.addCell("" + (i + 1)).setContentAsString(exCell.getStringCellValue());
                                }
                            }
                        }
                    }
                    if (spsheet.getColumnCount() <= 0) continue;
                    for (i = 1; i <= sheet.getLastRowNum() && !this.m_Stopped; ++i) {
                        if (this.isLoggingEnabled()) {
                            this.getLogger().info("data row: " + (i + 1));
                        }
                        spRow = spsheet.addRow("" + spsheet.getRowCount());
                        exRow = sheet.getRow(i);
                        if (exRow == null) continue;
                        block13: for (int n = 0; n < exRow.getLastCellNum(); ++n) {
                            if (n >= spsheet.getHeaderRow().getCellCount() && this.m_AutoExtendHeader) {
                                spsheet.insertColumn(spsheet.getColumnCount(), "");
                            }
                            this.m_TextColumns.setMax(spsheet.getHeaderRow().getCellCount());
                            exCell = exRow.getCell(n);
                            if (exCell == null) {
                                spRow.addCell(n).setMissing();
                                continue;
                            }
                            int cellType = exCell.getCellType();
                            if (cellType == 2) {
                                cellType = exCell.getCachedFormulaResultType();
                            }
                            numeric = !this.m_TextColumns.isInRange(n);
                            switch (cellType) {
                                case 3: 
                                case 5: {
                                    if (this.m_MissingValue.length() == 0) {
                                        spRow.addCell(n).setMissing();
                                        continue block13;
                                    }
                                    spRow.addCell(n).setContent("");
                                    continue block13;
                                }
                                case 0: {
                                    if (HSSFDateUtil.isCellDateFormatted((Cell)exCell)) {
                                        spRow.addCell(n).setContent(dformat.format(HSSFDateUtil.getJavaDate((double)exCell.getNumericCellValue())));
                                        continue block13;
                                    }
                                    if (numeric) {
                                        spRow.addCell(n).setContent(Double.valueOf(exCell.getNumericCellValue()));
                                        continue block13;
                                    }
                                    spRow.addCell(n).setContentAsString(this.numericToString(exCell));
                                    continue block13;
                                }
                                default: {
                                    if (exCell.getStringCellValue().equals(this.m_MissingValue)) {
                                        spRow.addCell(n).setMissing();
                                        continue block13;
                                    }
                                    spRow.addCell(n).setContentAsString(exCell.getStringCellValue());
                                }
                            }
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception ioe) {
            this.getLogger().log(Level.SEVERE, "Failed to read range '" + this.m_SheetRange + "':", ioe);
            result = null;
            this.m_LastError = "Failed to read range '" + this.m_SheetRange + "' from stream!\n" + Utils.throwableToString((Throwable)ioe);
        }
        return result;
    }
}

