/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.logging.LoggingObject;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractHistory<T>
extends LoggingObject {
    private static final long serialVersionUID = 6838638921199269531L;
    public static final int MAX_HISTORY_COUNT = 10;
    public static final int MAX_HISTORY_LENGTH = 200;
    protected List<T> m_History;

    public AbstractHistory() {
        this.initialize();
    }

    protected void initialize() {
        this.m_History = new ArrayList<T>();
    }

    protected abstract T copy(T var1);

    public synchronized void clear() {
        this.m_History.clear();
    }

    public synchronized void add(T obj) {
        if (this.m_History.contains(obj = this.copy(obj))) {
            this.m_History.remove(obj);
        }
        this.m_History.add(0, obj);
        while (this.m_History.size() > 10) {
            this.m_History.remove(this.m_History.size() - 1);
        }
    }

    public synchronized int size() {
        return this.m_History.size();
    }

    public synchronized List<T> getHistory() {
        return this.m_History;
    }
}

