/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.ByteFormat;
import adams.core.Memory;
import adams.core.Placeholders;
import adams.core.Utils;
import adams.core.management.Java;
import adams.core.management.ProcessUtils;
import adams.env.Environment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class SystemInfo {
    protected Hashtable<String, String> m_Info;
    public static final String JVM_PID = "java.vm.pid";
    public static final String PROJECT_PREFIX = "project.";
    public static final String REVISIONS_PREFIX = "revisions.";
    public static final String PLACEHOLDER_PREFIX = "placeholder.";
    public static final String MEMORY_PREFIX = "memory.";
    public static final String ENV_PREFIX = "env.";

    public SystemInfo() {
        this.initialize();
    }

    protected void initialize() {
        String name;
        this.m_Info = new Hashtable();
        Properties props = System.getProperties();
        Enumeration<Object> enm = props.propertyNames();
        while (enm.hasMoreElements()) {
            name = (String)enm.nextElement();
            this.m_Info.put(name, (String)props.get(name));
        }
        enm = Placeholders.getSingleton().placeholders();
        while (enm.hasMoreElements()) {
            name = (String)enm.nextElement();
            this.m_Info.put(PLACEHOLDER_PREFIX + name, Placeholders.getSingleton().get(name));
        }
        this.m_Info.put("project.name", Environment.getInstance().getProject());
        this.m_Info.put("project.home", Environment.getInstance().getHome());
        this.m_Info.put("project.classpath.full", Java.getClassPath(false));
        this.m_Info.put("project.classpath.short", Java.getClassPath(true));
        this.m_Info.put("memory.current", ByteFormat.toMegaBytes(Memory.getSingleton().getCurrent(), 1));
        this.m_Info.put("memory.max", ByteFormat.toMegaBytes(Memory.getSingleton().getMax(), 1));
        for (String key : System.getenv().keySet()) {
            this.m_Info.put(ENV_PREFIX + key, System.getenv(key));
        }
        this.m_Info.put(JVM_PID, "" + ProcessUtils.getVirtualMachinePID());
    }

    public Hashtable<String, String> getInfo() {
        return this.m_Info;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(this.m_Info.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            result.append(key);
            result.append("=");
            result.append(Utils.backQuoteChars(this.m_Info.get(key)));
            result.append("\n");
        }
        return result.toString();
    }

    public static void main(String[] args) throws Exception {
        Class cls = args.length > 0 ? Class.forName(args[0]) : Environment.class;
        System.err.println("Using following environment class: " + cls.getName() + "\n");
        Environment.setEnvironmentClass(cls);
        System.out.println(new SystemInfo());
    }
}

