/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import JSci.maths.wavelet.IllegalScalingException;
import adams.core.io.FileUtils;
import adams.core.logging.LoggingLevel;
import adams.core.logging.LoggingObject;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractOption;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.DebugOptionProducer;
import adams.core.option.NestedConsumer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionManager;
import adams.core.option.OptionProducer;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public abstract class AbstractOptionProducer<O, I>
extends LoggingObject
implements OptionProducer<O, I> {
    private static final long serialVersionUID = 4502704821224667069L;
    protected OptionHandler m_Input;
    protected boolean m_UsePropertyNames;
    protected transient O m_Output;
    protected I m_LastGenerated;
    protected boolean m_OutputVariableValues;
    protected HashSet<String> m_SkippedProperties;

    public AbstractOptionProducer() {
        this.initialize();
    }

    protected void initialize() {
        this.m_LoggingLevel = LoggingLevel.OFF;
        this.m_UsePropertyNames = false;
        this.m_Output = this.initOutput();
        this.m_OutputVariableValues = this instanceof DebugOptionProducer;
        this.m_SkippedProperties = new HashSet();
    }

    protected void reset() {
        this.m_Input = null;
        this.m_Output = this.initOutput();
        this.m_LastGenerated = null;
    }

    @Override
    public abstract String globalInfo();

    @Override
    public synchronized void setLoggingLevel(LoggingLevel value) {
        this.m_LoggingLevel = value;
        this.m_Logger = null;
        this.reset();
    }

    @Override
    public String loggingLevelTipText() {
        return "The level of debugging output (0 = no output).";
    }

    protected String generateLoggingString(String s) {
        return s;
    }

    @Override
    public void setOutputVariableValues(boolean value) {
        this.m_OutputVariableValues = value;
        this.reset();
    }

    @Override
    public boolean getOutputVariableValues() {
        return this.m_OutputVariableValues;
    }

    @Override
    public String outputVariableValuesTipText() {
        return "Whether to output the values of variables instead of the variable placeholders.";
    }

    @Override
    public void setSkippedProperties(HashSet<String> value) {
        this.m_SkippedProperties = value;
        this.reset();
    }

    @Override
    public HashSet<String> getSkippedProperties() {
        return this.m_SkippedProperties;
    }

    @Override
    public boolean getUsePropertyNames() {
        return this.m_UsePropertyNames;
    }

    @Override
    public OptionHandler getInput() {
        return this.m_Input;
    }

    protected String getOptionIdentifier(AbstractOption option) {
        if (this.getUsePropertyNames()) {
            return option.getProperty();
        }
        return "-" + option.getCommandline();
    }

    protected abstract O initOutput();

    @Override
    public O getOutput() {
        if (this.m_Output == null) {
            this.m_Output = this.initOutput();
        }
        return this.m_Output;
    }

    protected Object getCurrentValue(AbstractOption option) {
        return option.getCurrentValue();
    }

    protected boolean isDefaultValue(AbstractArgumentOption option, Object value) {
        return option.isDefaultValue(value);
    }

    protected void preProduce(OptionManager manager, int index) {
    }

    @Override
    public abstract I processOption(BooleanOption var1);

    @Override
    public abstract I processOption(ClassOption var1);

    @Override
    public abstract I processOption(AbstractArgumentOption var1);

    @Override
    public I doProduce(AbstractOption option) {
        if (option instanceof BooleanOption) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info(this.generateLoggingString("produce/boolean") + ": " + option);
            }
            return this.processOption((BooleanOption)option);
        }
        if (option instanceof ClassOption) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info(this.generateLoggingString("produce/class") + ": " + option);
            }
            return this.processOption((ClassOption)option);
        }
        if (option instanceof AbstractArgumentOption) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info(this.generateLoggingString("produce/argument") + ": " + option);
            }
            return this.processOption((AbstractArgumentOption)option);
        }
        throw new IllegalScalingException("Unhandled type of option: " + option.getClass().getName());
    }

    protected void postProduce(OptionManager manager, int index) {
    }

    protected OptionHandler checkInput(OptionHandler object) {
        if (object == null) {
            throw new IllegalStateException("Input is null!");
        }
        return object;
    }

    protected void preProduce() {
        if (this.m_Output == null) {
            this.m_Output = this.initOutput();
        }
    }

    protected void doProduce(OptionManager manager) {
        List<AbstractOption> options = manager.getOptionsList();
        for (int i = 0; i < options.size(); ++i) {
            if (this.m_SkippedProperties.contains(options.get(i).getProperty())) continue;
            if (this.isLoggingEnabled()) {
                this.getLogger().info(this.generateLoggingString("preProduce") + ": " + manager.getOwner().getClass().getName());
            }
            this.preProduce(manager, i);
            if (this.isLoggingEnabled()) {
                this.getLogger().info(this.generateLoggingString("produce") + ": " + manager.getOwner().getClass().getName());
            }
            this.m_LastGenerated = this.doProduce(options.get(i));
            if (this.isLoggingEnabled()) {
                this.getLogger().fine(this.generateLoggingString("produce") + " --> " + this.m_LastGenerated);
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info(this.generateLoggingString("postProduce") + ": " + manager.getOwner().getClass().getName());
            }
            this.postProduce(manager, i);
        }
    }

    protected void postProduce() {
    }

    @Override
    public O produce(OptionHandler visitedObject) {
        this.reset();
        this.m_Input = this.checkInput(visitedObject);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("preVisit: " + this.m_Input.getClass().getName());
        }
        this.preProduce();
        if (this.isLoggingEnabled()) {
            this.getLogger().info("doVisit: " + this.m_Input.getClass().getName());
        }
        this.doProduce(this.getInput().getOptionManager());
        if (this.isLoggingEnabled()) {
            this.getLogger().info("postVisit: " + this.m_Input.getClass().getName());
        }
        this.postProduce();
        return this.getOutput();
    }

    @Override
    public abstract String toString();

    @Override
    public boolean write(String filename) {
        boolean result;
        try {
            BufferedWriter writer = filename.toLowerCase().endsWith(".gz") ? new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(filename)))) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename)));
            writer.write(this.toString());
            writer.newLine();
            writer.flush();
            writer.close();
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public void cleanUp() {
        this.m_Input = null;
        this.m_Output = null;
        this.m_LastGenerated = null;
    }

    public static String toString(Class<? extends OptionProducer> cls, OptionHandler handler) {
        String result = null;
        try {
            OptionProducer producer = cls.newInstance();
            producer.produce(handler);
            result = producer.toString();
            producer.cleanUp();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Object produce(Class<? extends OptionProducer> cls, OptionHandler handler) {
        Object result = null;
        try {
            OptionProducer producer = cls.newInstance();
            producer.produce(handler);
            result = producer.getOutput();
            producer.cleanUp();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void runProducer(Class producer, String[] args) {
        try {
            if (OptionUtils.helpRequested(args)) {
                System.out.println("Help requested...\n");
                System.out.println("\n");
                System.out.println("-env <environment class>\n");
                System.out.println("-input <file in nested format>\n");
                System.out.println("-output <for storing generated output>\n");
                System.out.println(" if no output file provided, output gets printed on stdout\n");
                System.out.println("\n");
            } else {
                Environment.setEnvironmentClass(Class.forName(OptionUtils.removeOption(args, "-env")));
                String input = OptionUtils.removeOption(args, "-input");
                if (input == null) {
                    throw new IllegalArgumentException("No input file specified!");
                }
                String output = OptionUtils.removeOption(args, "-output");
                OptionProducer producerInst = (OptionProducer)OptionUtils.forName(OptionProducer.class, producer.getName(), args);
                OptionHandler handler = AbstractOptionConsumer.fromString(NestedConsumer.class, new File(input));
                if (handler == null) {
                    throw new IllegalStateException("Failed to read input file: " + input);
                }
                producerInst.produce(handler);
                if (output == null) {
                    System.out.println(producerInst.toString());
                } else if (FileUtils.writeToFile(new File(output).getAbsolutePath(), (Object)producerInst.toString(), false)) {
                    System.out.println("Output written to: " + output);
                } else {
                    System.err.println("Failed!");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
    }
}

