/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.option.AbstractOptionConsumer;
import adams.core.option.RecursiveOptionConsumer;
import java.util.Stack;

public abstract class AbstractRecursiveOptionConsumer<C, V>
extends AbstractOptionConsumer<C, V>
implements RecursiveOptionConsumer {
    private static final long serialVersionUID = 4502704821224667069L;
    protected Stack m_Nesting;

    @Override
    protected void reset() {
        super.reset();
        this.m_Nesting = new Stack();
    }

    @Override
    protected String generateLoggingString(String s) {
        return this.getDebugIndentation() + s + "(" + this.getRecursionLevel() + ")";
    }

    @Override
    public int getRecursionLevel() {
        return this.m_Nesting.size();
    }

    protected String getDebugIndentation() {
        return this.getDebugIndentation(this.getRecursionLevel());
    }

    protected String getDebugIndentation(int level) {
        StringBuilder result = new StringBuilder(level * 2);
        for (int i = 0; i < level; ++i) {
            result.append("  ");
        }
        return result.toString();
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_Nesting = null;
    }
}

