/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.Utils;
import adams.core.Variables;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractCommandLineHandler;
import adams.core.option.AbstractOption;
import adams.core.option.AbstractRecursiveOptionConsumer;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.Conversion;
import adams.core.option.NestedFormatHelper;
import adams.core.option.OptionHandler;
import adams.core.option.OptionManager;
import gnu.trove.list.array.TIntArrayList;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

public class NestedConsumer
extends AbstractRecursiveOptionConsumer<List, List> {
    private static final long serialVersionUID = 3076988578982973033L;

    @Override
    public String globalInfo() {
        return "Processes the nested format (tab indentation in string representation, nested ArrayList objects in object representation).";
    }

    protected void getLineRange(List values, TIntArrayList range) {
        for (Object obj : values) {
            if (obj instanceof NestedFormatHelper.Line) {
                range.add(((NestedFormatHelper.Line)obj).getNumber());
                continue;
            }
            if (!(obj instanceof ArrayList)) continue;
            this.getLineRange((List)obj, range);
        }
    }

    protected String getLineRange(List values) {
        TIntArrayList range = new TIntArrayList();
        this.getLineRange(values, range);
        range.sort();
        if (range.size() > 0) {
            int max;
            int min = range.get(0);
            if (min == (max = range.get(range.size() - 1))) {
                return "" + min;
            }
            return min + "-" + max;
        }
        return null;
    }

    @Override
    protected OptionHandler initOutput() {
        OptionHandler result;
        try {
            NestedFormatHelper.Line line = (NestedFormatHelper.Line)((List)this.m_Input).get(0);
            result = (OptionHandler)Class.forName(Conversion.rename(line.getContent())).newInstance();
            ((List)this.m_Input).remove(0);
            this.m_Input = ((List)this.m_Input).size() > 0 ? (((List)this.m_Input).get(0) instanceof ArrayList ? (List)((List)this.m_Input).get(0) : new ArrayList()) : new ArrayList();
        }
        catch (Exception e) {
            String msg = "Failed to initialize output:";
            this.logError(msg + " " + e);
            this.getLogger().log(Level.SEVERE, msg, e);
            result = null;
        }
        return result;
    }

    @Override
    protected List convertToInput(String s) {
        try {
            ArrayList<String> lines = new ArrayList<String>(Arrays.asList(s.split("\n")));
            int offset = NestedFormatHelper.removeComments(lines);
            return NestedFormatHelper.linesToNested(lines, offset);
        }
        catch (Exception e) {
            String msg = "Failed to convert to input:";
            this.logError(msg + " " + e);
            this.getLogger().log(Level.SEVERE, msg, e);
            return null;
        }
    }

    @Override
    protected void processOption(BooleanOption option, List values) throws Exception {
        this.doProcessOption(option, values);
    }

    @Override
    protected void processOption(ClassOption option, List values) throws Exception {
        Method method = this.getWriteMethod(option);
        if (method == null) {
            return;
        }
        Object objects = Array.newInstance(option.getBaseClass(), values.size());
        String lines = this.getLineRange(values);
        for (int i = 0; i < values.size(); ++i) {
            if (values.get(i).getClass() == NestedFormatHelper.Line.class && Variables.isPlaceholder(((NestedFormatHelper.Line)values.get(i)).getContent())) {
                option.setVariable(((NestedFormatHelper.Line)values.get(i)).getContent());
                return;
            }
            List subset = (List)values.get(i);
            NestedFormatHelper.Line line = (NestedFormatHelper.Line)subset.get(0);
            line = new NestedFormatHelper.Line(line.getNumber(), Conversion.rename(line.getContent()));
            subset.set(0, line);
            Object object = Class.forName(((NestedFormatHelper.Line)subset.get(0)).getContent()).newInstance();
            if (object instanceof OptionHandler) {
                NestedConsumer consumer = new NestedConsumer();
                consumer.setLoggingLevel(this.getLoggingLevel());
                consumer.setInput(subset);
                object = consumer.consume();
                this.m_Errors.addAll(consumer.getErrors());
                this.m_Warnings.addAll(consumer.getWarnings());
                consumer.cleanUp();
            } else {
                List optionsSet = subset.size() > 1 ? (List)subset.get(1) : new ArrayList();
                String[] options = new String[optionsSet.size()];
                for (int n = 0; n < optionsSet.size(); ++n) {
                    options[n] = ((NestedFormatHelper.Line)optionsSet.get(n)).getContent();
                }
                AbstractCommandLineHandler handler = AbstractCommandLineHandler.getHandler(object);
                handler.setOptions(object, options);
            }
            Array.set(objects, i, object);
            this.checkDeprecation(object);
            if (!option.isMultiple()) break;
        }
        try {
            if (!option.isMultiple()) {
                method.invoke((Object)option.getOptionHandler(), Array.get(objects, 0));
            } else {
                method.invoke((Object)option.getOptionHandler(), objects);
            }
        }
        catch (Exception e) {
            String msg = "Failed to process class option '" + this.getOptionIdentifier(option) + "/" + option.getOptionHandler().getClass().getName() + "'" + (lines == null ? ": " : " (lines: " + lines + "):");
            this.logError(msg + "\n" + Utils.throwableToString(e));
            this.getLogger().log(Level.SEVERE, msg, e);
        }
    }

    @Override
    protected void processOption(AbstractArgumentOption option, List values) throws Exception {
        this.doProcessOption(option, values);
    }

    protected void doProcessOption(AbstractArgumentOption option, List values) throws Exception {
        Method method = this.getWriteMethod(option);
        if (method == null) {
            return;
        }
        Object objects = Array.newInstance(option.getBaseClass(), values.size());
        String lines = this.getLineRange(values);
        for (int i = 0; i < values.size(); ++i) {
            if (Variables.isPlaceholder(((NestedFormatHelper.Line)values.get(i)).getContent())) {
                option.setVariable(((NestedFormatHelper.Line)values.get(i)).getContent());
                return;
            }
            Array.set(objects, i, option.valueOf(((NestedFormatHelper.Line)values.get(i)).getContent()));
            if (!option.isMultiple()) break;
        }
        try {
            if (!option.isMultiple()) {
                method.invoke((Object)option.getOptionHandler(), Array.get(objects, 0));
            } else {
                method.invoke((Object)option.getOptionHandler(), objects);
            }
        }
        catch (Exception e) {
            String msg = "Failed to process argument option '" + this.getOptionIdentifier(option) + "/" + option.getOptionHandler().getClass().getName() + "'" + (lines == null ? ": " : " (lines: " + lines + "):");
            this.logError(msg + "\n" + Utils.throwableToString(e));
            this.getLogger().log(Level.SEVERE, msg, e);
        }
    }

    protected ArrayList collectValues(AbstractOption option, List input) {
        ArrayList<NestedFormatHelper.Line> result = new ArrayList<NestedFormatHelper.Line>();
        boolean hasArg = option instanceof AbstractArgumentOption;
        boolean isBool = option instanceof BooleanOption;
        int i = 0;
        String optionStr = this.getOptionIdentifier(option);
        while (i < input.size()) {
            if (input.get(i).getClass() == NestedFormatHelper.Line.class) {
                if (Conversion.renameOption(option.getOptionHandler().getClass().getName(), ((NestedFormatHelper.Line)input.get(i)).getContent()).equals(optionStr)) {
                    input.remove(i);
                    if (!hasArg) continue;
                    if (isBool) {
                        if (i < input.size()) {
                            String str = input.get(i).toString();
                            if (str.equals("true") || str.equals("false") || str.startsWith("@{")) {
                                result.add(new NestedFormatHelper.Line(str));
                                input.remove(i);
                                continue;
                            }
                            result.add(new NestedFormatHelper.Line("true"));
                            continue;
                        }
                        result.add(new NestedFormatHelper.Line("true"));
                        continue;
                    }
                    if (i >= input.size()) continue;
                    result.add((NestedFormatHelper.Line)input.get(i));
                    input.remove(i);
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
        return result;
    }

    @Override
    protected void doConsume(OptionManager manager, List input) {
        int i = 0;
        while (i < input.size()) {
            String msg;
            if (input.get(i).getClass() != NestedFormatHelper.Line.class) {
                ++i;
                continue;
            }
            String cmdline = ((NestedFormatHelper.Line)input.get(i)).getContent();
            if (cmdline.length() == 0) {
                ++i;
                continue;
            }
            if (!cmdline.startsWith("-")) continue;
            cmdline = cmdline.substring(1);
            cmdline = Conversion.renameOption(manager.getOwner().getClass().getName(), cmdline);
            AbstractOption option = manager.findByFlag(cmdline);
            ArrayList values = null;
            if (option == null) {
                msg = "Failed to find option (" + manager.getOwner().getClass().getName() + "): " + cmdline + "\n  --> Command-line: " + Utils.flatten(input, " ");
                this.logWarning(msg);
                this.getLogger().severe(msg);
                input.remove(i);
                if (i < input.size() && input.get(i).getClass() == NestedFormatHelper.Line.class) {
                    if (((NestedFormatHelper.Line)input.get(i)).getContent().startsWith("-")) continue;
                    input.remove(i);
                    continue;
                }
                if (i >= input.size()) continue;
                input.remove(i);
                continue;
            }
            if (option instanceof AbstractArgumentOption) {
                values = this.collectValues(option, input);
                if (values.size() == 0) {
                    msg = "No argument supplied for option '" + option + "' (" + manager.getOwner().getClass().getName() + ")!";
                    this.logWarning(msg);
                    this.getLogger().severe(msg);
                }
            } else if (option instanceof BooleanOption) {
                this.collectValues(option, input);
            }
            try {
                this.processOption(option, values);
            }
            catch (Exception e) {
                msg = "Failed to process option '" + this.getOptionIdentifier(option) + "/" + manager.getOwner().getClass().getName() + "':";
                this.logError(msg + " " + Utils.throwableToString(e));
                this.getLogger().log(Level.SEVERE, msg, e);
            }
        }
    }
}

