/*
 * Decompiled with CFR 0.152.
 */
package adams.data;

import adams.core.DateFormat;
import adams.core.HelpProvider;
import adams.core.base.AbstractBaseString;

public class DateFormatString
extends AbstractBaseString
implements HelpProvider {
    private static final long serialVersionUID = -7134897961930112280L;

    public DateFormatString() {
        this("yyyy-MM-dd");
    }

    public DateFormatString(String s) {
        super(s);
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        try {
            new DateFormat(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getTipText() {
        return "Format string for date and/or time.";
    }

    public DateFormat toDateFormat() {
        return new DateFormat(this.getValue());
    }

    @Override
    public String getHelpURL() {
        return "http://docs.oracle.com/javase/6/docs/api/java/text/SimpleDateFormat.html";
    }

    @Override
    public String getHelpDescription() {
        return "Information on the format string";
    }

    @Override
    public String getHelpTitle() {
        return null;
    }

    @Override
    public String getHelpIcon() {
        return "help2.png";
    }
}

