/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.management.LocaleHelper;
import adams.core.management.OptionHandlingLocaleSupporter;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversionFromString;
import java.util.Locale;

public class StringToDouble
extends AbstractConversionFromString
implements OptionHandlingLocaleSupporter {
    private static final long serialVersionUID = -7171309518664810125L;
    protected Locale m_Locale;

    @Override
    public String globalInfo() {
        return "Turns a String into a Double.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "locale", this.m_Locale);
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("locale", "locale", LocaleHelper.getSingleton().getDefault());
    }

    @Override
    public void setLocale(Locale value) {
        this.m_Locale = value;
        this.reset();
    }

    @Override
    public Locale getLocale() {
        return this.m_Locale;
    }

    @Override
    public String localeTipText() {
        return "The locale to use for formatting the numbers.";
    }

    @Override
    public Class generates() {
        return Double.class;
    }

    @Override
    protected Object doConvert() throws Exception {
        try {
            return LocaleHelper.getSingleton().getNumberFormat(this.m_Locale).parse((String)this.m_Input).doubleValue();
        }
        catch (Exception e) {
            throw new Exception("Failed to parse: " + this.m_Input, e);
        }
    }
}

