/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.ClassCrossReference;
import adams.core.Utils;
import adams.data.conversion.AbstractStringConversion;
import adams.data.conversion.BackQuote;
import adams.data.conversion.Quote;
import adams.data.conversion.UnBackQuote;

public class UnQuote
extends AbstractStringConversion
implements ClassCrossReference {
    private static final long serialVersionUID = -1362461206623476937L;
    protected Quote.QuoteType m_QuoteType;

    @Override
    public String globalInfo() {
        return "Removes the quotes (single or double) surrounding a string. Also unbackquotes new lines and tabs.";
    }

    @Override
    public Class[] getClassCrossReferences() {
        return new Class[]{Quote.class, BackQuote.class, UnBackQuote.class};
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("quote-type", "quoteType", (Object)Quote.QuoteType.DOUBLE);
    }

    public void setQuoteType(Quote.QuoteType value) {
        this.m_QuoteType = value;
        this.reset();
    }

    public Quote.QuoteType getQuoteType() {
        return this.m_QuoteType;
    }

    public String quoteTypeTipText() {
        return "The type of quote to use.";
    }

    @Override
    protected Object doConvert() throws Exception {
        String input = (String)this.m_Input;
        switch (this.m_QuoteType) {
            case DOUBLE: {
                return Utils.unDoubleQuote(input);
            }
            case SINGLE: {
                return Utils.unquote(input);
            }
        }
        throw new IllegalStateException("Unhandled quote type: " + (Object)((Object)this.m_QuoteType));
    }
}

