/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.Properties;
import adams.core.Utils;
import adams.data.io.output.AbstractReportWriter;
import adams.data.report.AbstractField;
import adams.data.report.Report;
import java.io.FileWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

public abstract class AbstractSimpleReportWriter<T extends Report>
extends AbstractReportWriter<T> {
    private static final long serialVersionUID = 1281189381638349284L;

    @Override
    public String globalInfo() {
        return "Writes reports in properties file format.";
    }

    @Override
    public String getFormatDescription() {
        return "Properties file format";
    }

    @Override
    public String[] getFormatExtensions() {
        return new String[]{"report"};
    }

    @Override
    protected boolean writeData(T data) {
        boolean result;
        Properties props = new Properties();
        props.setInteger("Parent ID", ((Report)data).getDatabaseID());
        List<AbstractField> fields = ((Report)data).getFields();
        for (int i = 0; i < fields.size(); ++i) {
            props.setProperty(fields.get(i).toString(), ((Report)data).getValue(fields.get(i)).toString());
            props.setProperty(fields.get(i).toString() + "\tDataType", fields.get(i).getDataType().toString());
        }
        try {
            StringWriter swriter = new StringWriter();
            props.store(swriter, "Simple report format (= Java properties file format)");
            Object[] lines = swriter.toString().split("\n");
            Arrays.sort(lines);
            FileWriter writer = new FileWriter(this.m_Output.getAbsolutePath());
            writer.write(Utils.flatten(lines, "\n"));
            writer.close();
            result = true;
        }
        catch (Exception e) {
            result = false;
            this.getLogger().log(Level.SEVERE, "Failed to write to " + this.m_Output, e);
        }
        return result;
    }
}

