/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.io.FileUtils;
import adams.data.io.output.AbstractTextWriterWithFilenameGenerator;

public class TextFileWriter
extends AbstractTextWriterWithFilenameGenerator {
    private static final long serialVersionUID = 2481561390856324348L;
    protected boolean m_Append;

    @Override
    public String globalInfo() {
        return "Writes the content to a text file.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("append", "append", false);
    }

    public void setAppend(boolean value) {
        this.m_Append = value;
        this.reset();
    }

    public boolean getAppend() {
        return this.m_Append;
    }

    public String appendTipText() {
        return "If enabled, the content gets appended rather than rewriting the file.";
    }

    @Override
    protected String doWrite(String content, String name) {
        String filename = this.createFilename(name);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Filename: " + filename);
        }
        boolean ok = FileUtils.writeToFile(filename, content, this.m_Append, this.m_Encoding.stringValue());
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Result (append=" + this.m_Append + "): " + ok);
        }
        if (ok) {
            return filename;
        }
        return null;
    }
}

