/*
 * Decompiled with CFR 0.152.
 */
package adams.data.random;

import adams.core.Randomizable;
import adams.data.random.AbstractSeededRandomNumberGenerator;

public abstract class AbstractDistributionBasedRandomNumberGenerator<T extends Number>
extends AbstractSeededRandomNumberGenerator<T>
implements Randomizable {
    private static final long serialVersionUID = -4193009658719437993L;
    protected double m_Mean;
    protected double m_Stdev;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("mean", "mean", this.getDefaultMean());
        this.m_OptionManager.add("stdev", "stdev", this.getDefaultStdev(), 1.0E-6, null);
    }

    protected double getDefaultMean() {
        return 0.0;
    }

    protected double getDefaultStdev() {
        return 1.0;
    }

    public void setMean(double value) {
        this.m_Mean = value;
        this.reset();
    }

    public double getMean() {
        return this.m_Mean;
    }

    public String meanTipText() {
        return "The mean to use for the distribution.";
    }

    public void setStdev(double value) {
        if (value > 0.0) {
            this.m_Stdev = value;
            this.reset();
        } else {
            this.getLogger().severe("Standard deviation must be >0, provided: " + value);
        }
    }

    public double getStdev() {
        return this.m_Stdev;
    }

    public String stdevTipText() {
        return "The standard deviation to use for the distribution.";
    }
}

