/*
 * Decompiled with CFR 0.152.
 */
package adams.data.report;

import adams.core.CloneHandler;
import adams.core.Mergeable;
import adams.core.Properties;
import adams.core.Utils;
import adams.core.logging.LoggingLevel;
import adams.core.logging.LoggingObject;
import adams.core.option.AbstractOption;
import adams.data.id.MutableDatabaseIDHandler;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.PrefixField;
import adams.data.report.PrefixOnlyField;
import adams.data.report.SuffixField;
import adams.data.report.SuffixOnlyField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;

public class Report
extends LoggingObject
implements Serializable,
CloneHandler<Report>,
Comparable,
Mergeable<Report>,
MutableDatabaseIDHandler {
    private static final long serialVersionUID = -8377544506571885570L;
    public static final String FIELD_DUMMYREPORT = "Dummy report";
    public static final String FIELD_EXCLUDED = "Excluded";
    public static final String PROPERTY_PARENTID = "Parent ID";
    public static final String DATATYPE_SUFFIX = "\tDataType";
    protected Hashtable<AbstractField, Object> m_Params = new Hashtable();
    protected Hashtable<String, AbstractField> m_Fields;
    protected int m_DatabaseID = -1;

    public Report() {
        this.initFields();
    }

    public synchronized void setLoggingLevel(LoggingLevel value) {
        this.m_LoggingLevel = value;
        this.m_Logger = null;
    }

    @Override
    public LoggingLevel getLoggingLevel() {
        return this.m_LoggingLevel;
    }

    @Override
    public void setDatabaseID(int value) {
        this.m_DatabaseID = value;
    }

    @Override
    public int getDatabaseID() {
        return this.m_DatabaseID;
    }

    protected void initFields() {
        this.m_Fields = new Hashtable();
        this.addField(new Field(FIELD_DUMMYREPORT, DataType.BOOLEAN));
        this.addField(new Field(FIELD_EXCLUDED, DataType.BOOLEAN));
    }

    public void addField(AbstractField field) {
        this.m_Fields.put(field.getName(), field);
    }

    public boolean hasField(String field) {
        return this.m_Fields.containsKey(field);
    }

    public boolean hasField(AbstractField field) {
        return this.m_Fields.containsKey(field.getName());
    }

    public DataType getFieldType(AbstractField field) {
        if (this.hasField(field)) {
            return this.m_Fields.get(field.getName()).getDataType();
        }
        return DataType.UNKNOWN;
    }

    public List<AbstractField> getFields() {
        ArrayList<AbstractField> result = new ArrayList<AbstractField>();
        for (AbstractField key : this.m_Params.keySet()) {
            result.add(key);
        }
        return result;
    }

    public List<AbstractField> getFields(PrefixOnlyField prefix) {
        ArrayList<AbstractField> result = new ArrayList<AbstractField>();
        String str = prefix.getPrefix();
        for (AbstractField key : this.m_Params.keySet()) {
            if (!key.isCompound() || !key.getPrefix().equals(str)) continue;
            result.add(key);
        }
        return result;
    }

    public List<AbstractField> getFields(SuffixOnlyField suffix) {
        ArrayList<AbstractField> result = new ArrayList<AbstractField>();
        String str = suffix.getSuffix();
        for (AbstractField key : this.m_Params.keySet()) {
            if (!key.isCompound() || !key.getSuffix().equals(str)) continue;
            result.add(key);
        }
        return result;
    }

    public List<PrefixOnlyField> getPrefixFields() {
        HashSet<PrefixField> fields = new HashSet<PrefixField>();
        for (AbstractField key : this.m_Params.keySet()) {
            if (!key.isCompound()) continue;
            fields.add(new PrefixField(key));
        }
        ArrayList<PrefixOnlyField> result = new ArrayList<PrefixOnlyField>(fields);
        Collections.sort(result);
        return result;
    }

    public List<SuffixOnlyField> getSuffixFields() {
        HashSet<SuffixField> fields = new HashSet<SuffixField>();
        for (AbstractField key : this.m_Params.keySet()) {
            if (!key.isCompound()) continue;
            fields.add(new SuffixField(key));
        }
        ArrayList<SuffixOnlyField> result = new ArrayList<SuffixOnlyField>(fields);
        Collections.sort(result);
        return result;
    }

    public void addParameter(String key, String value) {
        AbstractField f = this.m_Fields.get(key);
        if (f == null) {
            this.m_Params.put(new Field(key, DataType.UNKNOWN), Field.fixString(value));
        } else {
            Object o = f.valueOf(value);
            if (o == null) {
                this.getLogger().info("Null object from: " + value.toString());
                return;
            }
            this.m_Params.put(f, o);
        }
    }

    public void addParameter(String key, Object value) {
        AbstractField f = this.m_Fields.get(key);
        if (f == null) {
            this.m_Params.put(new Field(key, DataType.UNKNOWN), Field.fixString(value.toString()));
        } else {
            Object o = f.valueOf(value.toString());
            if (o == null) {
                this.getLogger().info("Null object from: " + value.toString());
                return;
            }
            this.m_Params.put(f, value);
        }
    }

    public void setParams(Hashtable<AbstractField, Object> ht) {
        this.m_Params = ht;
    }

    public Hashtable<AbstractField, Object> getParams() {
        return this.m_Params;
    }

    public boolean hasValue(AbstractField key) {
        return this.getValue(key) != null;
    }

    public boolean hasValue(String key) {
        return this.hasValue(new Field(key, DataType.UNKNOWN));
    }

    protected boolean hasValues(AbstractField[] fields) {
        boolean result = true;
        for (AbstractField field : fields) {
            if (this.hasValue(field)) continue;
            result = false;
            break;
        }
        return result;
    }

    public boolean hasValues(String[] fields) {
        AbstractField[] ffields = new AbstractField[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            ffields[i] = new Field(fields[i], DataType.UNKNOWN);
        }
        return this.hasValues(ffields);
    }

    public void setValue(AbstractField key, Object value) {
        if (value instanceof Byte) {
            value = new Double(((Byte)value).doubleValue());
        } else if (value instanceof Short) {
            value = new Double(((Short)value).doubleValue());
        } else if (value instanceof Integer) {
            value = new Double(((Integer)value).doubleValue());
        } else if (value instanceof Long) {
            value = new Double(((Long)value).doubleValue());
        } else if (value instanceof Float) {
            value = new Double(((Float)value).doubleValue());
        } else if (value instanceof Character) {
            value = new String(value.toString());
        }
        if (value instanceof String) {
            value = Field.fixString((String)value);
        }
        if (value instanceof String) {
            if (key.getDataType() == DataType.NUMERIC) {
                value = new Double((String)value);
            } else if (key.getDataType() == DataType.BOOLEAN) {
                value = new Boolean((String)value);
            }
        } else if (value instanceof Double) {
            if (key.getDataType() == DataType.STRING || key.getDataType() == DataType.UNKNOWN) {
                value = value.toString();
            }
        } else if (value instanceof Boolean && (key.getDataType() == DataType.STRING || key.getDataType() == DataType.UNKNOWN)) {
            value = value.toString();
        }
        this.m_Params.put(key, value);
    }

    public void setNumericValue(String key, double value) {
        this.setValue(new Field(key, DataType.NUMERIC), value);
    }

    public void setStringValue(String key, String value) {
        this.setValue(new Field(key, DataType.STRING), value);
    }

    public void setBooleanValue(String key, boolean value) {
        this.setValue(new Field(key, DataType.BOOLEAN), value);
    }

    public Object getValue(AbstractField key) {
        return this.m_Params.get(key);
    }

    public String getStringValue(String key) {
        return this.getStringValue(new Field(key, DataType.STRING));
    }

    public String getStringValue(AbstractField key) {
        if (this.m_Params.containsKey(key)) {
            return this.m_Params.get(key).toString();
        }
        return null;
    }

    public Boolean getBooleanValue(String key) {
        return this.getBooleanValue(new Field(key, DataType.BOOLEAN));
    }

    public Boolean getBooleanValue(AbstractField key) {
        if (this.m_Params.containsKey(key)) {
            return (Boolean)this.m_Params.get(key);
        }
        return null;
    }

    public Double getDoubleValue(String key) {
        return this.getDoubleValue(new Field(key, DataType.NUMERIC));
    }

    public Double getDoubleValue(AbstractField key) {
        if (this.m_Params.containsKey(key)) {
            return (Double)this.m_Params.get(key);
        }
        return null;
    }

    public Object removeValue(AbstractField key) {
        return this.m_Params.remove(key);
    }

    public void update() {
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ArrayList<AbstractField> fields = new ArrayList<AbstractField>();
        for (AbstractField s : this.m_Params.keySet()) {
            fields.add(s);
        }
        Collections.sort(fields);
        for (int i = 0; i < fields.size(); ++i) {
            AbstractField f = (AbstractField)fields.get(i);
            String val = this.m_Params.get(f).toString();
            ret.append(f.toParseableString() + ": " + val + "\n");
        }
        return ret.toString();
    }

    @Override
    public Report getClone() {
        Report result = Report.newInstance(this);
        if (result != null) {
            result.assign(this);
        }
        return result;
    }

    public void assign(Report other) {
        this.m_Fields = (Hashtable)other.m_Fields.clone();
        this.m_Params = (Hashtable)other.m_Params.clone();
        this.m_LoggingLevel = other.m_LoggingLevel;
        this.m_DatabaseID = other.m_DatabaseID;
    }

    public void setDummyReport(boolean value) {
        this.addParameter(FIELD_DUMMYREPORT, "" + value);
    }

    public boolean isDummyReport() {
        Field field = new Field(FIELD_DUMMYREPORT, DataType.BOOLEAN);
        if (this.hasValue(field)) {
            return this.getBooleanValue(field);
        }
        return false;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        int result = 0;
        if (!(o instanceof Report)) {
            return -1;
        }
        Report qr = (Report)o;
        if (result == 0) {
            result = new Integer(this.m_Params.size()).compareTo(new Integer(qr.m_Params.size()));
        }
        ArrayList<AbstractField> keys = new ArrayList<AbstractField>();
        Enumeration<AbstractField> enm = this.m_Params.keys();
        while (enm.hasMoreElements()) {
            keys.add(enm.nextElement());
        }
        Collections.sort(keys);
        ArrayList<AbstractField> keysQr = new ArrayList<AbstractField>();
        enm = this.m_Params.keys();
        while (enm.hasMoreElements()) {
            keysQr.add(enm.nextElement());
        }
        Collections.sort(keysQr);
        for (int i = 0; i < keys.size(); ++i) {
            result = ((AbstractField)keys.get(i)).compareTo(keysQr.get(i));
            if (result == 0) {
                result = this.m_Params.get(keys.get(i)).toString().compareTo(this.m_Params.get(keysQr.get(i)).toString());
            }
            if (result != 0) break;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Report)) {
            return false;
        }
        Report qr = (Report)obj;
        return this.m_Params.equals(qr.m_Params);
    }

    public int hashCode() {
        return this.m_Params.hashCode();
    }

    public Report intersect(Report report) {
        Report result = Report.newInstance(report);
        if (result != null) {
            Hashtable<AbstractField, Object> params = new Hashtable<AbstractField, Object>();
            for (AbstractField key : this.getFields()) {
                if (!report.hasValue(key)) continue;
                params.put(key, this.getValue(key));
            }
            result.setParams(params);
        }
        return result;
    }

    public Report minus(Report report) {
        Report result = Report.newInstance(report);
        if (result != null) {
            Hashtable<AbstractField, Object> params = new Hashtable<AbstractField, Object>();
            for (AbstractField key : this.getFields()) {
                if (report.hasValue(key)) continue;
                params.put(key, this.getValue(key));
            }
            result.setParams(params);
        }
        return result;
    }

    @Override
    public void mergeWith(Report other) {
        List<AbstractField> fields = other.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            if (this.hasValue(fields.get(i))) continue;
            this.setValue(fields.get(i), other.getValue(fields.get(i)));
        }
    }

    public static Report newInstance(Report report) {
        Report result;
        try {
            result = (Report)report.getClass().newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public Properties toProperties() {
        Properties result = new Properties();
        result.setInteger(PROPERTY_PARENTID, this.getDatabaseID());
        List<AbstractField> fields = this.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            result.setProperty(fields.get(i).toString(), this.getValue(fields.get(i)).toString());
            result.setProperty(fields.get(i).toString() + DATATYPE_SUFFIX, fields.get(i).getDataType().toString());
        }
        return result;
    }

    public static Report parseReport(String s) {
        Report result = null;
        if (!s.equals("null") && s.length() > 0) {
            result = new Report();
            String[] lines = s.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                int pos = lines[i].indexOf(": ");
                if (pos == -1) continue;
                String fieldStr = lines[i].substring(0, pos);
                String contentStr = lines[i].substring(pos + 2);
                AbstractField field = Field.parseField(fieldStr);
                Object content = field.valueOf(contentStr);
                result.m_Params.put(field, content);
            }
        }
        return result;
    }

    public static Report parseProperties(Properties props) {
        Report result = new Report();
        Enumeration<?> enm = props.propertyNames();
        while (enm.hasMoreElements()) {
            DataType type;
            String name = (String)enm.nextElement();
            if (name.endsWith(DATATYPE_SUFFIX)) continue;
            if (name.equals(PROPERTY_PARENTID)) {
                result.setDatabaseID(props.getInteger(PROPERTY_PARENTID, -1));
            }
            if ((type = DataType.valueOf((AbstractOption)null, props.getProperty(name + DATATYPE_SUFFIX, "U"))) == null) {
                type = DataType.UNKNOWN;
            }
            if (type == DataType.NUMERIC) {
                result.setValue(new Field(name, type), Utils.toDouble(props.getProperty(name)));
                continue;
            }
            if (type == DataType.BOOLEAN) {
                result.setValue(new Field(name, type), new Boolean(props.getProperty(name)));
                continue;
            }
            result.setValue(new Field(name, type), props.getProperty(name));
        }
        return result;
    }
}

