/*
 * Decompiled with CFR 0.152.
 */
package adams.data.sequence;

import adams.core.Utils;
import adams.data.container.AbstractDataPoint;
import adams.data.container.DataPoint;

public class XYSequencePoint
extends AbstractDataPoint {
    private static final long serialVersionUID = 2354312871454097142L;
    protected String m_ID;
    protected double m_X;
    protected double m_Y;

    public XYSequencePoint() {
        this(Double.NaN);
    }

    public XYSequencePoint(double x) {
        this(null, x, Double.NaN);
    }

    public XYSequencePoint(double x, double y) {
        this(null, x, y);
    }

    public XYSequencePoint(String id, double x) {
        this(id, x, Double.NaN);
    }

    public XYSequencePoint(String id, double x, double y) {
        this.setID(id);
        this.setX(x);
        this.setY(y);
    }

    public void setX(double value) {
        this.m_X = value;
    }

    public double getX() {
        return this.m_X;
    }

    public void setY(double value) {
        this.m_Y = value;
    }

    public double getY() {
        return this.m_Y;
    }

    public void setID(String value) {
        this.m_ID = value == null ? "" : value;
    }

    public String getID() {
        return this.m_ID;
    }

    public boolean hasID() {
        return this.m_ID.length() > 0;
    }

    @Override
    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        int result = 0;
        if (!(o instanceof XYSequencePoint)) {
            return -1;
        }
        XYSequencePoint other = (XYSequencePoint)o;
        result = this.getID().compareTo(other.getID());
        if (result == 0) {
            result = new Double(this.getX()).compareTo(other.getX());
        }
        if (result == 0) {
            result = new Double(this.getY()).compareTo(other.getY());
        }
        return result;
    }

    @Override
    public void assign(DataPoint other) {
        super.assign(other);
        XYSequencePoint point = (XYSequencePoint)other;
        this.setX(point.getX());
        this.setY(point.getY());
    }

    @Override
    public String toString() {
        return Utils.quote(this.getID()) + "," + Utils.doubleToString(this.getX(), 12) + "," + Utils.doubleToString(this.getY(), 12);
    }
}

