/*
 * Decompiled with CFR 0.152.
 */
package adams.data.sequence;

import adams.data.container.DataPoint;
import adams.data.container.DataPointComparator;
import adams.data.sequence.XYSequencePoint;

public class XYSequencePointComparator<X extends Number, Y extends Number>
extends DataPointComparator {
    private static final long serialVersionUID = -5536677097973106152L;
    protected Comparison m_Comparison;

    public XYSequencePointComparator() {
        this(Comparison.X, true);
    }

    public XYSequencePointComparator(Comparison comp, boolean ascending) {
        super(ascending);
        this.m_Comparison = comp;
    }

    public Comparison getComparison() {
        return this.m_Comparison;
    }

    @Override
    public int compare(DataPoint o1, DataPoint o2) {
        int result;
        XYSequencePoint p1 = (XYSequencePoint)o1;
        XYSequencePoint p2 = (XYSequencePoint)o2;
        if (this.m_Comparison == Comparison.Y) {
            result = new Double(p1.getY()).compareTo(p2.getY());
        } else if (this.m_Comparison == Comparison.X) {
            result = new Double(p1.getX()).compareTo(p2.getX());
        } else if (this.m_Comparison == Comparison.X_AND_Y) {
            result = new Double(p1.getX()).compareTo(p2.getX());
            if (result == 0) {
                result = new Double(p1.getY()).compareTo(p2.getY());
            }
        } else {
            throw new IllegalStateException("Unhandled comparison type: " + (Object)((Object)this.m_Comparison));
        }
        if (!this.m_Ascending) {
            result *= -1;
        }
        return result;
    }

    public static enum Comparison {
        X,
        Y,
        X_AND_Y;

    }
}

