/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.core.base.BasePassword;
import adams.core.option.AbstractOptionHandler;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.DatabaseConnectionEstablisher;
import adams.db.DatabaseConnectionHandler;
import adams.db.DatabaseConnectionParameterHandler;

public abstract class AbstractDatabaseObjectWithOptionHandling
extends AbstractOptionHandler
implements DatabaseConnectionHandler,
DatabaseConnectionEstablisher,
DatabaseConnectionParameterHandler {
    private static final long serialVersionUID = -8800746361445333658L;
    protected transient AbstractDatabaseConnection m_dbc;
    protected String m_URL;
    protected String m_User;
    protected BasePassword m_Password;
    protected boolean m_NoDatabaseConnect;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("url", "URL", DatabaseConnection.getSingleton().getDefaultURL(), false);
        this.m_OptionManager.add("user", "user", DatabaseConnection.getSingleton().getDefaultUser(), false);
        this.m_OptionManager.add("password", "password", DatabaseConnection.getSingleton().getDefaultPassword(), false);
        this.m_OptionManager.add("no-connect", "noDatabaseConnect", false);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_dbc = null;
    }

    @Override
    public void setDatabaseConnection(AbstractDatabaseConnection value) {
        this.m_dbc = value;
        if (value != null) {
            this.m_URL = value.getURL();
            this.m_User = value.getUser();
            this.m_Password = value.getPassword();
        } else {
            this.m_URL = "";
            this.m_User = "";
            this.m_Password = new BasePassword("");
        }
    }

    @Override
    public AbstractDatabaseConnection getDatabaseConnection() {
        return this.m_dbc;
    }

    @Override
    public void setURL(String value) {
        this.m_URL = value;
    }

    @Override
    public String getURL() {
        return this.m_URL;
    }

    @Override
    public String URLTipText() {
        return "The database URL.";
    }

    @Override
    public void setUser(String value) {
        this.m_User = value;
    }

    @Override
    public String getUser() {
        return this.m_User;
    }

    @Override
    public String userTipText() {
        return "The database user.";
    }

    @Override
    public void setPassword(BasePassword value) {
        this.m_Password = value;
    }

    @Override
    public BasePassword getPassword() {
        return this.m_Password;
    }

    @Override
    public String passwordTipText() {
        return "The password of the database user.";
    }

    public void setNoDatabaseConnect(boolean value) {
        this.m_NoDatabaseConnect = value;
    }

    public boolean getNoDatabaseConnect() {
        return this.m_NoDatabaseConnect;
    }

    public String noDatabaseConnectTipText() {
        return "If set to true, no database connection is established.";
    }

    protected AbstractDatabaseConnection createDatabaseConnection() {
        return DatabaseConnection.getSingleton(this.m_URL, this.m_User, this.m_Password);
    }

    @Override
    public void establishDatabaseConnection() {
        if (!this.m_NoDatabaseConnect) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Connecting to database");
            }
            this.m_dbc = this.createDatabaseConnection();
        } else if (this.isLoggingEnabled()) {
            this.getLogger().info("Skipping database connection");
        }
    }
}

