/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.QuickInfoHelper;
import adams.core.io.AbstractFilenameGenerator;
import adams.core.io.NullFilenameGenerator;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;

public class FileExists
extends AbstractBooleanCondition {
    private static final long serialVersionUID = -6986050060604039765L;
    protected PlaceholderFile m_File;
    protected AbstractFilenameGenerator m_Generator;

    @Override
    public String globalInfo() {
        return "Evaluates to 'true' if the file exists.\nIf a filename generator other than " + NullFilenameGenerator.class.getName() + " is specified, then this " + "takes precedence over the supplied filename (uses the token passing through).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("file", "file", new PlaceholderFile("."));
        this.m_OptionManager.add("generator", "generator", new NullFilenameGenerator());
    }

    public void setFile(PlaceholderFile value) {
        this.m_File = value;
        this.reset();
    }

    public PlaceholderFile getFile() {
        return this.m_File;
    }

    public String fileTipText() {
        return "The file to look for.";
    }

    public void setGenerator(AbstractFilenameGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractFilenameGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The generator to use for generating the filename; uses the token passing through.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "file", this.m_File, "file: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "generator", this.m_Generator, ", generator: ");
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public String setUp(Actor owner) {
        String result = super.setUp(owner);
        if (result == null && this.m_File == null) {
            result = "No file provided!";
        }
        return result;
    }

    @Override
    protected boolean doEvaluate(Actor owner, Token token) {
        PlaceholderFile file = !(this.m_Generator instanceof NullFilenameGenerator) ? new PlaceholderFile(this.m_Generator.generate(token.getPayload())) : this.m_File;
        return file.exists() && !file.isDirectory();
    }
}

