/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.ClassLocator;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;

public class HasInterface
extends AbstractBooleanCondition {
    private static final long serialVersionUID = 912094591109587908L;
    protected String m_Interface;
    protected Class m_Class;

    @Override
    public String globalInfo() {
        return "Evaluates to 'true' if the objects implement the specified interface.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("interface", "interface", Cloneable.class.getName());
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Class = null;
    }

    public void setInterface(String value) {
        this.m_Interface = value;
        this.reset();
    }

    public String getInterface() {
        return this.m_Interface;
    }

    public String interfaceTipText() {
        return "The interface class that the objects must implement.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "interface", this.m_Interface, "interface: ");
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public String setUp(Actor owner) {
        String result = super.setUp(owner);
        if (result == null) {
            if (this.m_Interface == null || this.m_Interface.trim().length() == 0) {
                result = "No interface class provided!";
            } else {
                try {
                    this.m_Class = Class.forName(this.m_Interface);
                }
                catch (Exception e) {
                    result = "Failed to load interface class: " + e;
                }
            }
        }
        return result;
    }

    @Override
    protected boolean doEvaluate(Actor owner, Token token) {
        if (token != null && token.getPayload() != null) {
            return ClassLocator.hasInterface(this.m_Class, token.getPayload().getClass());
        }
        return false;
    }
}

