/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.test;

import adams.flow.condition.test.AbstractTestCondition;

public class MultiCondition
extends AbstractTestCondition {
    private static final long serialVersionUID = -3833261282991705L;
    protected AbstractTestCondition[] m_Conditions;

    @Override
    public String globalInfo() {
        return "Checks multiple conditions. Stops checking when the first fails.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("condition", "subConditions", new AbstractTestCondition[0]);
    }

    public void setSubConditions(AbstractTestCondition[] value) {
        this.m_Conditions = value;
        this.reset();
    }

    public AbstractTestCondition[] getSubConditions() {
        return this.m_Conditions;
    }

    public String subConditionsTipText() {
        return "The conditions to check.";
    }

    @Override
    protected String performTest() {
        String result = null;
        for (int i = 0; i < this.m_Conditions.length; ++i) {
            result = this.m_Conditions[i].getTestResult();
            if (result == null) continue;
            result = "Failed condition #" + (i + 1) + ": " + result;
            break;
        }
        return result;
    }
}

