/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.container;

import adams.flow.container.AbstractContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class SequencePlotterContainer
extends AbstractContainer {
    private static final long serialVersionUID = 7610036927945350224L;
    public static final String VALUE_PLOTNAME = "PlotName";
    public static final String VALUE_X = "X";
    public static final String VALUE_Y = "Y";
    public static final String VALUE_CONTENTTYPE = "Content type";
    public static final String DEFAULT_PLOTNAME = "Plot";
    public static final String VALUE_ERROR_X = "Error X";
    public static final String VALUE_ERROR_Y = "Error Y";
    public static final String VALUE_METADATA = "MetaData";

    public SequencePlotterContainer() {
        this(DEFAULT_PLOTNAME, (Comparable)Double.valueOf(0.0));
    }

    public SequencePlotterContainer(String plotName, Comparable y) {
        this(plotName, y, ContentType.PLOT);
    }

    public SequencePlotterContainer(String plotName, Comparable y, ContentType type) {
        this(plotName, null, y, type);
    }

    public SequencePlotterContainer(Comparable x, Comparable y) {
        this(DEFAULT_PLOTNAME, x, y);
    }

    public SequencePlotterContainer(String plotName, Comparable x, Comparable y) {
        this(plotName, x, y, ContentType.PLOT);
    }

    public SequencePlotterContainer(String plotName, Comparable x, Comparable y, ContentType type) {
        this(plotName, x, y, null, null, type);
    }

    public SequencePlotterContainer(String plotName, Comparable x, Comparable y, Double[] errorX, Double[] errorY, ContentType type) {
        this.store(VALUE_PLOTNAME, plotName);
        this.store(VALUE_X, x);
        this.store(VALUE_Y, y);
        this.store(VALUE_CONTENTTYPE, (Object)type);
        this.store(VALUE_ERROR_X, errorX);
        this.store(VALUE_ERROR_Y, errorY);
    }

    @Override
    public Iterator<String> names() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(VALUE_PLOTNAME);
        result.add(VALUE_X);
        result.add(VALUE_Y);
        result.add(VALUE_CONTENTTYPE);
        result.add(VALUE_ERROR_X);
        result.add(VALUE_ERROR_Y);
        result.add(VALUE_METADATA);
        return result.iterator();
    }

    public Object addMetaData(String key, Object value) {
        if (value == null) {
            return null;
        }
        if (!this.hasValue(VALUE_METADATA)) {
            this.setValue(VALUE_METADATA, new HashMap());
        }
        HashMap meta = (HashMap)this.getValue(VALUE_METADATA);
        return meta.put(key, value);
    }

    public boolean hasMetaData() {
        return this.hasValue(VALUE_METADATA) && ((HashMap)this.getValue(VALUE_METADATA)).size() > 0;
    }

    public HashMap<String, Object> getMetaData() {
        return (HashMap)this.getValue(VALUE_METADATA);
    }

    @Override
    public boolean isValid() {
        return (this.hasValue(VALUE_PLOTNAME) && this.hasValue(VALUE_Y) && !this.hasValue(VALUE_Y) && this.hasValue(VALUE_CONTENTTYPE)) | (this.hasValue(VALUE_PLOTNAME) && this.hasValue(VALUE_X) && this.hasValue(VALUE_Y) && this.hasValue(VALUE_CONTENTTYPE));
    }

    public static enum ContentType {
        PLOT,
        MARKER,
        OVERLAY;

    }
}

