/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.Pausable;
import adams.core.Variables;
import adams.event.FlowPauseStateEvent;
import adams.event.FlowPauseStateListener;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import adams.flow.core.Compatibility;
import adams.flow.core.ControlActor;
import adams.flow.core.InputConsumer;
import adams.flow.core.PauseStateHandler;
import adams.flow.core.PauseStateManager;
import adams.flow.core.SubFlowWrapUp;
import java.util.HashSet;

public abstract class AbstractControlActor
extends AbstractActor
implements ControlActor,
ActorHandler,
Pausable,
FlowPauseStateListener,
SubFlowWrapUp {
    private static final long serialVersionUID = -7471817724012995179L;
    protected Compatibility m_Compatibility;
    protected PauseStateManager m_PauseStateManager;
    protected boolean m_SetUpSubActors;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Compatibility = new Compatibility();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_SetUpSubActors = false;
    }

    @Override
    public void setHeadless(boolean value) {
        super.setHeadless(value);
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).setHeadless(value);
        }
    }

    @Override
    public void setParent(AbstractActor value) {
        super.setParent(value);
        if (value != null) {
            this.updateParent();
        }
    }

    @Override
    protected void forceVariables(Variables value) {
        super.forceVariables(value);
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).setVariables(value);
        }
    }

    @Override
    public abstract ActorHandlerInfo getActorHandlerInfo();

    @Override
    public abstract int size();

    public int active() {
        int result = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).getSkip()) continue;
            ++result;
        }
        return result;
    }

    @Override
    public AbstractActor firstActive() {
        AbstractActor result = null;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).getSkip()) continue;
            result = this.get(i);
            break;
        }
        return result;
    }

    @Override
    public AbstractActor lastActive() {
        AbstractActor result = null;
        for (int i = this.size() - 1; i >= 0; --i) {
            if (this.get(i).getSkip()) continue;
            result = this.get(i);
            break;
        }
        return result;
    }

    public AbstractActor firstInputConsumer() {
        AbstractActor result = null;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).getSkip() || !(this.get(i) instanceof InputConsumer)) continue;
            result = this.get(i);
            break;
        }
        return result;
    }

    @Override
    public abstract AbstractActor get(int var1);

    @Override
    public abstract void set(int var1, AbstractActor var2);

    @Override
    public abstract int indexOf(String var1);

    protected void updateParent() {
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).setParent(null);
            this.get(i).setParent(this);
        }
    }

    @Override
    public boolean canInspectOptions(Class cls) {
        if (cls == AbstractActor[].class) {
            return false;
        }
        if (cls == AbstractActor.class) {
            return false;
        }
        return super.canInspectOptions(cls);
    }

    protected String setUpSubActors() {
        String result = null;
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < this.size(); ++i) {
            ActorUtils.uniqueName(this.get(i), names);
            names.add(this.get(i).getName());
            if (this.get(i).getSkip() || (result = this.get(i).setUp()) == null) continue;
            result = this.get(i).getFullName() + ": " + result;
            break;
        }
        return result;
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            result = this.setUpSubActors();
        }
        if (this.getRoot() instanceof PauseStateHandler) {
            this.m_PauseStateManager = ((PauseStateHandler)((Object)this.getRoot())).getPauseStateManager();
            if (this.m_PauseStateManager != null) {
                this.m_PauseStateManager.addListener(this);
            }
        } else {
            this.m_PauseStateManager = null;
        }
        if (result == null) {
            String msg = this.check();
            if (this.isLoggingEnabled()) {
                this.getLogger().info("check: " + (msg == null ? "OK" : msg));
            }
            if (msg != null) {
                result = "Check failed: " + msg;
            }
        }
        if (result == null) {
            this.m_SetUpSubActors = true;
        }
        return result;
    }

    @Override
    public String check() {
        return null;
    }

    @Override
    protected String preExecute() {
        String result = null;
        if (!this.m_SetUpSubActors) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Setting up sub-flow again");
            }
            result = this.setUpSubActors();
            if (this.isLoggingEnabled() && result != null) {
                this.getLogger().info("Setting up of subflow failed: " + result);
            }
        }
        if (result == null) {
            result = super.preExecute();
        }
        return result;
    }

    @Override
    public void wrapUp() {
        this.wrapUpSubFlow();
        super.wrapUp();
    }

    @Override
    public void cleanUp() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).getSkip()) continue;
            this.get(i).cleanUp();
        }
        super.cleanUp();
        this.m_SetUpSubActors = false;
    }

    @Override
    public void destroy() {
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).destroy();
        }
        super.destroy();
        this.m_SetUpSubActors = false;
    }

    @Override
    public void pauseExecution() {
        if (this.m_PauseStateManager != null) {
            this.m_PauseStateManager.pause(this);
        }
    }

    @Override
    public boolean isPaused() {
        if (this.m_PauseStateManager != null) {
            return this.m_PauseStateManager.isPaused();
        }
        return false;
    }

    @Override
    public void resumeExecution() {
        if (this.m_PauseStateManager != null) {
            this.m_PauseStateManager.resume(this);
        }
    }

    @Override
    public void stopExecution() {
        if (this.m_PauseStateManager != null && this.m_PauseStateManager.isPaused()) {
            this.m_PauseStateManager.resume(this);
        }
        super.stopExecution();
    }

    @Override
    public void flowPauseStateChanged(FlowPauseStateEvent e) {
    }

    @Override
    public void wrapUpSubFlow() {
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Wrapping up sub-flow");
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).getSkip()) continue;
            this.get(i).wrapUp();
        }
        this.m_SetUpSubActors = false;
    }

    @Override
    public boolean isSubFlowWrappedUp() {
        return !this.m_SetUpSubActors;
    }
}

