/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.AbstractContainer;
import adams.flow.control.Tee;
import adams.flow.core.Token;

public class ContainerValuePicker
extends Tee {
    private static final long serialVersionUID = 8352837834646017416L;
    protected String m_ValueName;
    protected boolean m_SwitchOutputs;

    @Override
    public String globalInfo() {
        return "Picks a named value from any container object and tees it off.\nWith the 'switch-outputs' option it is possible to forward the named value and teeing off the container instead.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("value", "valueName", "Classification");
        this.m_OptionManager.add("switch-outputs", "switchOutputs", false);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_MinimumActiveActors = this.m_SwitchOutputs ? 0 : 1;
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "valueName", this.m_ValueName);
        result = result + QuickInfoHelper.toString((OptionHandler)this, "switchOutputs", this.m_SwitchOutputs, "[outputs switched]", " ");
        if (super.getQuickInfo() != null) {
            result = result + ", " + super.getQuickInfo();
        }
        return result;
    }

    public void setValueName(String value) {
        this.m_ValueName = value;
        this.reset();
    }

    public String getValueName() {
        return this.m_ValueName;
    }

    public String valueNameTipText() {
        return "The name of the value to tee off.";
    }

    public void setSwitchOutputs(boolean value) {
        this.m_SwitchOutputs = value;
        this.reset();
    }

    public boolean getSwitchOutputs() {
        return this.m_SwitchOutputs;
    }

    public String switchOutputsTipText() {
        return "Whether to switch the output for the tee actors with the one normally being forwarded.";
    }

    protected Token extract(Token token) {
        AbstractContainer cont;
        Object value;
        Token result = null;
        if (token.getPayload() instanceof AbstractContainer && (value = (cont = (AbstractContainer)token.getPayload()).getValue(this.m_ValueName)) != null) {
            result = new Token(value);
        }
        return result;
    }

    @Override
    protected Token createTeeToken(Token token) {
        Token result = null;
        result = this.m_SwitchOutputs ? token : this.extract(token);
        return result;
    }

    protected boolean canProcessToken(Token token) {
        return this.createTeeToken(token) != null;
    }

    @Override
    protected boolean canProcessInput(Token token) {
        return super.canProcessInput(token) && this.canProcessToken(token);
    }

    @Override
    protected String doExecute() {
        String result = super.doExecute();
        if (this.m_SwitchOutputs && result == null) {
            this.m_OutputToken = this.extract(this.m_OutputToken);
        }
        return result;
    }
}

