/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.QuickInfoHelper;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.ControlActor;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class DesktopScreenshot
extends AbstractActor
implements ControlActor,
InputConsumer,
OutputProducer {
    private static final long serialVersionUID = -7346814880631564292L;
    public static final String BACKUP_INPUT = "input";
    protected Token m_InputToken;
    protected Token m_OutputToken;
    protected PlaceholderFile m_OutputFile;
    protected String m_ScreenshotResult;

    @Override
    public String globalInfo() {
        return "Takes a screenshot of the desktop whenever a token passes through.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-file", "outputFile", new PlaceholderFile("screenshot.png"));
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_InputToken = null;
        this.m_OutputToken = null;
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_InputToken != null) {
            result.put(BACKUP_INPUT, this.m_InputToken);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INPUT)) {
            this.m_InputToken = (Token)state.get(BACKUP_INPUT);
            state.remove(BACKUP_INPUT);
        }
        super.restoreState(state);
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "outputFile", this.m_OutputFile);
    }

    public void setOutputFile(PlaceholderFile value) {
        this.m_OutputFile = value;
        this.reset();
    }

    public PlaceholderFile getOutputFile() {
        return this.m_OutputFile;
    }

    public String outputFileTipText() {
        return "The output file; the extension determines the file format.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public void input(Token token) {
        this.m_InputToken = token;
    }

    @Override
    protected String doExecute() {
        this.m_ScreenshotResult = null;
        if (!this.m_Headless) {
            try {
                Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
                Rectangle rect = new Rectangle(size);
                Robot robot = new Robot();
                BufferedImage image = robot.createScreenCapture(rect);
                this.getLogger().info("Saving to: " + this.m_OutputFile);
                ImageWriter writer = null;
                Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(FileUtils.getExtension(this.m_OutputFile));
                if (!iter.hasNext()) {
                    throw new Exception("No writer available for " + FileUtils.getExtension(this.m_OutputFile) + "!");
                }
                writer = iter.next();
                ImageOutputStream ios = ImageIO.createImageOutputStream(this.m_OutputFile.getAbsoluteFile());
                writer.setOutput(ios);
                writer.write(null, new IIOImage(image, null, null), null);
                ios.flush();
                writer.dispose();
                ios.close();
            }
            catch (Exception e) {
                this.m_ScreenshotResult = this.handleException("Failed to save screenshot to: " + this.m_OutputFile, e);
            }
        }
        String result = this.m_ScreenshotResult;
        this.m_ScreenshotResult = null;
        this.m_OutputToken = this.m_InputToken;
        return result;
    }

    @Override
    public String execute() {
        String result = super.execute();
        if (this.m_Skip) {
            this.m_OutputToken = this.m_InputToken;
        }
        return result;
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }

    @Override
    public void wrapUp() {
        this.m_InputToken = null;
        this.m_OutputToken = null;
        super.wrapUp();
    }
}

