/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.control.AbstractDirectedControlActor;
import adams.flow.control.AbstractDirector;
import adams.flow.control.Sequence;
import adams.flow.control.Storage;
import adams.flow.control.StorageName;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import adams.flow.core.InputConsumer;
import adams.flow.core.Token;
import adams.flow.sink.Null;
import adams.flow.source.StringConstants;

public class IfStorageValue
extends AbstractDirectedControlActor {
    private static final long serialVersionUID = 185561131623293880L;
    protected String m_Cache;
    protected StorageName m_StorageName;
    protected AbstractActor m_ThenActor;
    protected AbstractActor m_ElseActor;

    @Override
    public String globalInfo() {
        return "An If-Then-Else source actor for storage values. If a storage value is available, the 'Then' branch gets executed, otherwise the 'Else' branch.\nWhereas the 'Then' branch receives the storage value (in case this branch accepts input), the 'Else' branch needs to produce its own data, i.e., having a source actor.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("cache", "cache", "");
        this.m_OptionManager.add("storage-name", "storageName", new StorageName());
        this.m_OptionManager.add("then", "thenActor", this.getDefaultThen());
        this.m_OptionManager.add("else", "elseActor", this.getDefaultElse());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_ThenActor = this.getDefaultThen();
        this.m_ElseActor = this.getDefaultElse();
    }

    protected AbstractActor getDefaultThen() {
        Sequence result = new Sequence();
        result.setName("then");
        Null actor = new Null();
        result.setActors(new AbstractActor[]{actor});
        return result;
    }

    protected AbstractActor getDefaultElse() {
        Sequence result = new Sequence();
        result.setName("else");
        StringConstants actor = new StringConstants();
        result.setActors(new AbstractActor[]{actor});
        return result;
    }

    @Override
    protected AbstractDirector newDirector() {
        return new IfStorageValueDirector();
    }

    public void setCache(String value) {
        this.m_Cache = value;
        this.reset();
    }

    public String getCache() {
        return this.m_Cache;
    }

    public String cacheTipText() {
        return "The name of the cache to retrieve the value from; uses the regular storage if left empty.";
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the stored value to retrieve.";
    }

    public void setThenActor(AbstractActor value) {
        ActorUtils.uniqueName(value, this, 0);
        this.m_ThenActor = value;
        this.reset();
        this.updateParent();
    }

    public AbstractActor getThenActor() {
        return this.m_ThenActor;
    }

    public String thenActorTipText() {
        return "The actor of the 'then' branch.";
    }

    public void setElseActor(AbstractActor value) {
        ActorUtils.uniqueName(value, this, 1);
        this.m_ElseActor = value;
        this.reset();
        this.updateParent();
    }

    public AbstractActor getElseActor() {
        return this.m_ElseActor;
    }

    public String elseActorTipText() {
        return "The actor of the 'else' branch.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "storageName", this.m_StorageName.getValue());
        String value = QuickInfoHelper.toString((OptionHandler)this, "cache", this.m_Cache.length() > 0 ? this.m_Cache : "", " cache: ");
        if (value != null) {
            result = result + value;
        }
        if (super.getQuickInfo() != null) {
            result = result + ", " + super.getQuickInfo();
        }
        return result;
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public AbstractActor get(int index) {
        if (index == 0) {
            return this.m_ThenActor;
        }
        if (index == 1) {
            return this.m_ElseActor;
        }
        throw new IndexOutOfBoundsException("Only two items available, requested index: " + index);
    }

    @Override
    public void set(int index, AbstractActor actor) {
        if (index == 0) {
            this.setThenActor(actor);
        } else if (index == 1) {
            this.setElseActor(actor);
        } else {
            this.getLogger().severe("Index out of range: " + index);
        }
    }

    @Override
    public int indexOf(String actor) {
        if (this.m_ThenActor.getName().equals(actor)) {
            return 0;
        }
        if (this.m_ElseActor.getName().equals(actor)) {
            return 1;
        }
        return -1;
    }

    @Override
    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo(false, ActorExecution.PARALLEL, true);
    }

    @Override
    public String check() {
        if (this.m_ElseActor instanceof ActorHandler) {
            ActorHandler handler = (ActorHandler)((Object)this.m_ElseActor);
            AbstractActor[] actors = new AbstractActor[handler.size()];
            for (int i = 0; i < handler.size(); ++i) {
                actors[i] = handler.get(i);
            }
            return ActorUtils.checkForSource(actors);
        }
        return ActorUtils.checkForSource(this.m_ElseActor);
    }

    public static class IfStorageValueDirector
    extends AbstractDirector {
        private static final long serialVersionUID = 8414511259688024553L;
        protected Object m_StoredValue;

        protected void setIfThenElseActor(AbstractDirectedControlActor value) {
            super.setControlActor(value);
        }

        public void setControlActor(AbstractDirectedControlActor value) {
            if (value instanceof IfStorageValue || value == null) {
                this.setIfThenElseActor(value);
            } else {
                System.err.println("Control actor must be a IfStorageValue actor (provided: " + (value != null ? value.getClass().getName() : "-null-") + ")!");
            }
        }

        protected boolean doThen() {
            boolean result;
            IfStorageValue owner = (IfStorageValue)this.m_ControlActor;
            Storage storage = owner.getStorageHandler().getStorage();
            this.m_StoredValue = null;
            if (owner.getCache().length() == 0) {
                if (storage.has(owner.getStorageName())) {
                    this.m_StoredValue = storage.get(owner.getStorageName());
                }
            } else if (storage.has(owner.getCache(), owner.getStorageName())) {
                this.m_StoredValue = storage.get(owner.getCache(), owner.getStorageName());
            }
            boolean bl = result = this.m_StoredValue != null;
            if (this.isLoggingEnabled()) {
                this.getLogger().info("doThen:\n- cache name: " + owner.getCache() + "\n" + "- storage name: " + owner.getStorageName() + "\n" + "  --> " + result + " (" + this.m_StoredValue + ")");
            }
            return result;
        }

        @Override
        public String execute() {
            String result;
            AbstractActor branch = this.doThen() ? ((IfStorageValue)this.m_ControlActor).getThenActor() : ((IfStorageValue)this.m_ControlActor).getElseActor();
            try {
                if (this.m_StoredValue != null && branch instanceof InputConsumer) {
                    Token token = new Token(this.m_StoredValue);
                    if (branch.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                        branch.getFlowExecutionListeningSupporter().getFlowExecutionListener().preInput(branch, token);
                    }
                    ((InputConsumer)((Object)branch)).input(token);
                    if (branch.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                        branch.getFlowExecutionListeningSupporter().getFlowExecutionListener().postInput(branch);
                    }
                }
                if (branch.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                    branch.getFlowExecutionListeningSupporter().getFlowExecutionListener().preExecute(branch);
                }
                result = branch.execute();
                if (branch.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                    branch.getFlowExecutionListeningSupporter().getFlowExecutionListener().postExecute(branch);
                }
            }
            catch (Exception e) {
                result = this.handleException(branch.getFullName() + " generated the following exception: ", e);
            }
            if (result != null) {
                result = branch.getErrorHandler().handleError(branch, "execute", result);
            }
            this.m_StoredValue = null;
            return result;
        }

        @Override
        public void cleanUp() {
            this.m_StoredValue = null;
            super.cleanUp();
        }
    }
}

