/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.QuickInfoHelper;
import adams.core.Variables;
import adams.core.VariablesHandler;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.flow.control.ScopeHandler;
import adams.flow.control.Storage;
import adams.flow.control.StorageHandler;
import adams.flow.control.StorageName;
import adams.flow.control.Trigger;
import adams.flow.core.FlowVariables;
import java.util.HashSet;

public class LocalScopeTrigger
extends Trigger
implements VariablesHandler,
StorageHandler,
ScopeHandler {
    private static final long serialVersionUID = -8344934611549310497L;
    protected transient Storage m_LocalStorage;
    protected FlowVariables m_LocalVariables;
    protected HashSet<String> m_CallableNames;
    protected boolean m_EnforceCallableNameCheck;
    protected ScopeHandler.ScopeHandling m_ScopeHandlingVariables;
    protected BaseRegExp m_VariablesFilter;
    protected ScopeHandler.ScopeHandling m_ScopeHandlingStorage;
    protected BaseRegExp m_StorageFilter;
    protected boolean m_PropagateVariables;
    protected BaseRegExp m_VariablesRegExp;
    protected boolean m_PropagateStorage;
    protected BaseRegExp m_StorageRegExp;

    @Override
    public String globalInfo() {
        return "Executes the sub-actors whenever a token gets passed through, just like the " + Trigger.class.getName() + " actor, but also provides " + "its own scope for variables and internal storage.\n" + "It is possible to 'propagate' or 'leak' variables and storage items " + "from within the local scope back to the output scope. However, " + "storage items from caches cannot be propagated.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("scope-handling-variables", "scopeHandlingVariables", (Object)ScopeHandler.ScopeHandling.EMPTY);
        this.m_OptionManager.add("variables-filter", "variablesFilter", new BaseRegExp(".*"));
        this.m_OptionManager.add("propagate-variables", "propagateVariables", false);
        this.m_OptionManager.add("variables-regexp", "variablesRegExp", new BaseRegExp(".*"));
        this.m_OptionManager.add("scope-handling-storage", "scopeHandlingStorage", (Object)ScopeHandler.ScopeHandling.EMPTY);
        this.m_OptionManager.add("storage-filter", "storageFilter", new BaseRegExp(".*"));
        this.m_OptionManager.add("propagate-storage", "propagateStorage", false);
        this.m_OptionManager.add("storage-regexp", "storageRegExp", new BaseRegExp(".*"));
    }

    @Override
    public String getQuickInfo() {
        String result = "variables [";
        result = result + QuickInfoHelper.toString((OptionHandler)this, "scopeHandlingVariables", (Object)this.m_ScopeHandlingVariables, "scope: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "variablesFilter", this.m_VariablesFilter, "filter: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "propagateVariables", this.m_PropagateVariables ? "propagate" : "no propagation", ", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "variablesRegExp", this.m_VariablesRegExp, ", regexp: ");
        result = result + "]";
        result = result + ", storage [";
        result = result + QuickInfoHelper.toString((OptionHandler)this, "scopeHandlingStorage", (Object)this.m_ScopeHandlingStorage, "scope: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "storageFilter", this.m_StorageFilter, "filter: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "propagateStorage", this.m_PropagateStorage ? "propagate" : "no propagation", ", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "storageRegExp", this.m_StorageRegExp, ", regexp: ");
        result = result + "]";
        return result;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_CallableNames = new HashSet();
        this.m_EnforceCallableNameCheck = true;
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_CallableNames.clear();
    }

    public void setScopeHandlingVariables(ScopeHandler.ScopeHandling value) {
        this.m_ScopeHandlingVariables = value;
        this.reset();
    }

    public ScopeHandler.ScopeHandling getScopeHandlingVariables() {
        return this.m_ScopeHandlingVariables;
    }

    public String scopeHandlingVariablesTipText() {
        return "Defines how variables are handled in the local scope; whether to start with empty set, a copy of the outer scope variables or share variables with the outer scope.";
    }

    public void setVariablesFilter(BaseRegExp value) {
        this.m_VariablesFilter = value;
        this.reset();
    }

    public BaseRegExp getVariablesFilter() {
        return this.m_VariablesFilter;
    }

    public String variablesFilterTipText() {
        return "The regular expression that variable names must match in order to get into the local scope (when using " + (Object)((Object)ScopeHandler.ScopeHandling.COPY) + ").";
    }

    public void setPropagateVariables(boolean value) {
        this.m_PropagateVariables = value;
        this.reset();
    }

    public boolean getPropagateVariables() {
        return this.m_PropagateVariables;
    }

    public String propagateVariablesTipText() {
        return "If enabled and variables are not shared with outer scope, variables that match the specified regular expression get propagated to the outer scope.";
    }

    public void setVariablesRegExp(BaseRegExp value) {
        this.m_VariablesRegExp = value;
        this.reset();
    }

    public BaseRegExp getVariablesRegExp() {
        return this.m_VariablesRegExp;
    }

    public String variablesRegExpTipText() {
        return "The regular expression that variable names must match in order to get propagated.";
    }

    public void setScopeHandlingStorage(ScopeHandler.ScopeHandling value) {
        this.m_ScopeHandlingStorage = value;
        this.reset();
    }

    public ScopeHandler.ScopeHandling getScopeHandlingStorage() {
        return this.m_ScopeHandlingStorage;
    }

    public String scopeHandlingStorageTipText() {
        return "Defines how storage is handled in the local scope; whether to start with empty set, a (deep) copy of the outer scope storage or share the storage with the outer scope.";
    }

    public void setStorageFilter(BaseRegExp value) {
        this.m_StorageFilter = value;
        this.reset();
    }

    public BaseRegExp getStorageFilter() {
        return this.m_StorageFilter;
    }

    public String storageFilterTipText() {
        return "The regular expression that storage item names must match in order to get into the local scope (when using " + (Object)((Object)ScopeHandler.ScopeHandling.COPY) + ").";
    }

    public void setPropagateStorage(boolean value) {
        this.m_PropagateStorage = value;
        this.reset();
    }

    public boolean getPropagateStorage() {
        return this.m_PropagateStorage;
    }

    public String propagateStorageTipText() {
        return "If enabled and storage is not shared with outer scope, storage items which names match the specified regular expression get propagated to the outer scope.";
    }

    public void setStorageRegExp(BaseRegExp value) {
        this.m_StorageRegExp = value;
        this.reset();
    }

    public BaseRegExp getStorageRegExp() {
        return this.m_StorageRegExp;
    }

    public String storageRegExpTipText() {
        return "The regular expression that the names of storage items must match in order to get propagated.";
    }

    @Override
    public void setEnforceCallableNameCheck(boolean value) {
        this.m_EnforceCallableNameCheck = value;
    }

    @Override
    public boolean getEnforceCallableNameCheck() {
        return this.m_EnforceCallableNameCheck;
    }

    @Override
    public boolean isCallableNameUsed(String name) {
        if (!this.getEnforceCallableNameCheck()) {
            return false;
        }
        return this.m_CallableNames.contains(name);
    }

    @Override
    public String addCallableName(String name) {
        if (!this.getEnforceCallableNameCheck()) {
            return null;
        }
        if (this.isCallableNameUsed(name)) {
            return "Callable name '" + name + "' is already used in this scope ('" + this.getFullName() + "')!";
        }
        this.m_CallableNames.add(name);
        return null;
    }

    @Override
    public synchronized Storage getStorage() {
        if (this.m_LocalStorage == null) {
            switch (this.m_ScopeHandlingStorage) {
                case EMPTY: {
                    this.m_LocalStorage = new Storage();
                    break;
                }
                case COPY: {
                    this.m_LocalStorage = this.getParent().getStorageHandler().getStorage().getClone(this.m_StorageFilter);
                    break;
                }
                case SHARE: {
                    this.m_LocalStorage = this.getParent().getStorageHandler().getStorage();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled storage scope handling type: " + (Object)((Object)this.m_ScopeHandlingStorage));
                }
            }
        }
        return this.m_LocalStorage;
    }

    @Override
    public synchronized Variables getLocalVariables() {
        if (this.m_LocalVariables == null) {
            switch (this.m_ScopeHandlingVariables) {
                case EMPTY: {
                    this.m_LocalVariables = new FlowVariables();
                    this.m_LocalVariables.setFlow(this);
                    break;
                }
                case COPY: {
                    this.m_LocalVariables = new FlowVariables();
                    this.m_LocalVariables.assign(this.getParent().getVariables(), this.m_VariablesFilter);
                    this.m_LocalVariables.setFlow(this);
                    break;
                }
                case SHARE: {
                    this.m_LocalVariables = (FlowVariables)this.getParent().getVariables();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled variables scope handling type: " + (Object)((Object)this.m_ScopeHandlingVariables));
                }
            }
            this.m_LocalVariables.setFlow(this);
        }
        return this.m_LocalVariables;
    }

    @Override
    public synchronized Variables getVariables() {
        return this.getLocalVariables();
    }

    @Override
    protected void forceVariables(Variables value) {
        super.forceVariables(this.getLocalVariables());
    }

    @Override
    protected String preExecute() {
        this.m_LocalStorage = null;
        this.m_LocalVariables = null;
        this.m_Actors.setVariables(this.getVariables());
        return super.preExecute();
    }

    @Override
    protected String postExecute() {
        String result = super.postExecute();
        if (!this.m_Stopped) {
            if (this.m_ScopeHandlingVariables != ScopeHandler.ScopeHandling.SHARE && this.m_PropagateVariables && this.m_LocalVariables != null) {
                for (String string : this.m_LocalVariables.nameSet()) {
                    if (!this.m_VariablesRegExp.isMatch(string)) continue;
                    this.getParent().getVariables().set(string, this.m_LocalVariables.get(string));
                    if (!this.isLoggingEnabled()) continue;
                    this.getLogger().fine("Propagating variable '" + string + "': " + this.m_LocalVariables.get(string));
                }
            }
            if (this.m_ScopeHandlingStorage != ScopeHandler.ScopeHandling.SHARE && this.m_PropagateStorage && this.m_LocalStorage != null) {
                for (StorageName storageName : this.m_LocalStorage.keySet()) {
                    if (!this.m_StorageRegExp.isMatch(storageName.getValue())) continue;
                    this.getParent().getStorageHandler().getStorage().put(storageName, this.m_LocalStorage.get(storageName));
                    if (!this.isLoggingEnabled()) continue;
                    this.getLogger().fine("Propagating storage '" + storageName + "': " + this.m_LocalStorage.get(storageName));
                }
            }
        }
        return result;
    }

    @Override
    public void cleanUp() {
        if (this.m_LocalVariables != null) {
            this.m_LocalVariables.cleanUp();
            this.m_LocalVariables = null;
        }
        if (this.m_LocalStorage != null) {
            this.m_LocalStorage.clear();
            this.m_LocalStorage = null;
        }
        this.m_CallableNames.clear();
        super.cleanUp();
    }
}

