/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.control.plotprocessor.AbstractPlotProcessor;
import adams.flow.control.plotprocessor.PassThrough;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class PlotProcessor
extends AbstractTransformer {
    private static final long serialVersionUID = 7830411664107227699L;
    public static final String BACKUP_ADDITIONALOUTPUT = "additional output";
    protected AbstractPlotProcessor m_Processor;
    protected boolean m_DropInput;
    protected List<Token> m_AdditionalOutputTokens;

    @Override
    public String globalInfo() {
        return "Applies the specified processing algorithm to the stream of plot containers passing through. Injects any additionally created plot containers into the stream.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("processor", "processor", new PassThrough());
        this.m_OptionManager.add("drop-input", "dropInput", false);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_AdditionalOutputTokens = new ArrayList<Token>();
    }

    @Override
    public String getQuickInfo() {
        String result = this.m_Processor.getQuickInfo();
        result = result == null ? QuickInfoHelper.toString((OptionHandler)this, "processor", this.m_Processor) : this.m_Processor.getClass().getSimpleName() + ": " + result;
        String value = QuickInfoHelper.toString((OptionHandler)this, "dropInput", this.m_DropInput, ", drop");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    public void setProcessor(AbstractPlotProcessor value) {
        this.m_Processor = value;
        this.reset();
    }

    public AbstractPlotProcessor getProcessor() {
        return this.m_Processor;
    }

    public String processorTipText() {
        return "The plot processor to apply to the stream of plot containers passing through.";
    }

    public void setDropInput(boolean value) {
        this.m_DropInput = value;
        this.reset();
    }

    public boolean getDropInput() {
        return this.m_DropInput;
    }

    public String dropInputTipText() {
        return "If enabled, then the input plot container is dropped.";
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_ADDITIONALOUTPUT);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_AdditionalOutputTokens != null) {
            result.put(BACKUP_ADDITIONALOUTPUT, this.m_AdditionalOutputTokens);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_ADDITIONALOUTPUT)) {
            this.m_AdditionalOutputTokens = (List)state.get(BACKUP_ADDITIONALOUTPUT);
            state.remove(BACKUP_ADDITIONALOUTPUT);
        }
        super.restoreState(state);
    }

    @Override
    public Class[] accepts() {
        return new Class[]{SequencePlotterContainer.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{SequencePlotterContainer.class};
    }

    @Override
    protected String doExecute() {
        this.m_AdditionalOutputTokens.clear();
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("input: " + this.m_InputToken.getPayload());
        }
        List<SequencePlotterContainer> cont = this.m_Processor.process((SequencePlotterContainer)this.m_InputToken.getPayload());
        String result = this.m_Processor.getLastError();
        if (result == null && cont != null) {
            for (SequencePlotterContainer c : cont) {
                this.m_AdditionalOutputTokens.add(new Token(c));
                if (!this.isLoggingEnabled()) continue;
                this.getLogger().fine("additional: " + c);
            }
        }
        if (!this.m_DropInput) {
            this.m_OutputToken = this.m_InputToken;
        }
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_AdditionalOutputTokens.size() > 0 || super.hasPendingOutput();
    }

    @Override
    public Token output() {
        Token result;
        if (this.m_AdditionalOutputTokens.size() > 0) {
            result = this.m_AdditionalOutputTokens.get(0);
            this.m_AdditionalOutputTokens.remove(0);
        } else {
            result = super.output();
        }
        return result;
    }

    @Override
    public void wrapUp() {
        this.m_AdditionalOutputTokens.clear();
        super.wrapUp();
    }

    @Override
    public void cleanUp() {
        this.m_Processor.cleanUp();
        super.cleanUp();
    }
}

