/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.DateUtils;
import adams.data.io.output.NullWriter;
import adams.flow.container.AbstractContainer;
import adams.flow.core.Token;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractTextDisplayPanel;
import adams.flow.sink.AbstractTextualDisplay;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.sendto.SendToActionUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import javax.swing.JTable;

public class ContainerDisplay
extends AbstractTextualDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = 3247255046513744115L;
    protected SpreadSheetTable m_Table;
    protected SpreadSheetTableModel m_TableModel;

    @Override
    public String globalInfo() {
        return "Actor for displaying any flow container.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("writer", "writer", new NullWriter());
    }

    @Override
    protected int getDefaultWidth() {
        return 640;
    }

    @Override
    protected int getDefaultHeight() {
        return 480;
    }

    @Override
    public void clearPanel() {
        this.m_TableModel = new SpreadSheetTableModel();
        this.m_Table = new SpreadSheetTable(this.m_TableModel);
    }

    @Override
    public BasePanel newPanel() {
        BasePanel result = new BasePanel(new BorderLayout());
        this.m_TableModel = new SpreadSheetTableModel();
        this.m_Table = new SpreadSheetTable(this.m_TableModel);
        result.add((Component)new BaseScrollPane(this.m_Table), "Center");
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{AbstractContainer.class};
    }

    @Override
    protected void display(Token token) {
        this.m_TableModel = new SpreadSheetTableModel(((AbstractContainer)token.getPayload()).toSpreadSheet());
        this.m_Table.setModel(this.m_TableModel);
    }

    @Override
    public AbstractDisplayPanel createDisplayPanel(Token token) {
        AbstractTextDisplayPanel result = new AbstractTextDisplayPanel(this.getClass().getSimpleName()){
            private static final long serialVersionUID = 3524967045456783678L;
            protected SpreadSheetTable m_Table;
            protected SpreadSheetTableModel m_TableModel;

            @Override
            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
                this.m_TableModel = new SpreadSheetTableModel();
                this.m_Table = new SpreadSheetTable(this.m_TableModel);
                this.add((Component)new BaseScrollPane(this.m_Table), "Center");
            }

            @Override
            public void display(Token token) {
                this.m_TableModel = new SpreadSheetTableModel(((AbstractContainer)token.getPayload()).toSpreadSheet());
                this.m_Table.setModel(this.m_TableModel);
            }

            @Override
            public ExtensionFileFilter getCustomTextFileFilter() {
                return ExtensionFileFilter.getCsvFileFilter();
            }

            @Override
            public String supplyText() {
                return this.m_TableModel.toSpreadSheet().toString();
            }

            @Override
            public void clearPanel() {
                this.m_TableModel = new SpreadSheetTableModel();
                this.m_Table.setModel(this.m_TableModel);
            }

            @Override
            public void cleanUp() {
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    @Override
    public boolean displayPanelRequiresScrollPane() {
        return false;
    }

    @Override
    protected String doExecute() {
        String result = null;
        if (this.m_Headless) {
            System.out.println("\n--> " + DateUtils.getTimestampFormatterMsecs().format(new Date()) + "\n");
            System.out.println(this.m_InputToken.getPayload());
        } else {
            result = super.doExecute();
        }
        return result;
    }

    @Override
    public ExtensionFileFilter getCustomTextFileFilter() {
        return ExtensionFileFilter.getCsvFileFilter();
    }

    @Override
    public String supplyText() {
        String result = null;
        if (this.m_TableModel != null) {
            result = this.m_TableModel.toSpreadSheet().toString();
        }
        return result;
    }

    @Override
    public Class[] getSendToClasses() {
        ArrayList<Class> result = new ArrayList<Class>(Arrays.asList(super.getSendToClasses()));
        if (!result.contains(JTable.class)) {
            result.add(JTable.class);
        }
        return result.toArray(new Class[result.size()]);
    }

    @Override
    public Object getSendToItem(Class[] cls) {
        Object result = null;
        if (SendToActionUtils.isAvailable(JTable.class, cls)) {
            result = this.m_Table;
            if (this.m_Table.getRowCount() == 0) {
                result = null;
            }
        } else {
            result = super.getSendToItem(cls);
        }
        return result;
    }
}

