/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.JsonSupporter;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.AbstractTextDisplayPanel;
import adams.flow.sink.DisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.flow.sink.TextSupplier;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.json.JsonTree;
import adams.gui.core.json.JsonTreeWithPreview;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONValue;

public class JsonDisplay
extends AbstractGraphicalDisplay
implements DisplayPanelProvider,
TextSupplier {
    private static final long serialVersionUID = 680299970232233254L;
    protected JsonSupporter m_Tree;
    protected boolean m_Preview;
    protected boolean m_Expand;
    protected boolean m_SortKeys;

    @Override
    public String globalInfo() {
        return "Displays a JSON object as tree structure.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("preview", "preview", false);
        this.m_OptionManager.add("expand", "expand", false);
        this.m_OptionManager.add("sort-keys", "sortKeys", false);
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, "preview", this.m_Preview, "preview", ", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "expand", this.m_Expand, "expand", ", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "sortKeys", this.m_SortKeys, "sort keys", ", ");
        return result;
    }

    public void setPreview(boolean value) {
        this.m_Preview = value;
        this.reset();
    }

    public boolean getPreview() {
        return this.m_Preview;
    }

    public String previewTipText() {
        return "If enabled, a text area is shown that displays the JSON object associated with the currently selected node in the tree.";
    }

    public void setExpand(boolean value) {
        this.m_Expand = value;
        this.reset();
    }

    public boolean getExpand() {
        return this.m_Expand;
    }

    public String expandTipText() {
        return "If enabled, the tree gets fully expanded.";
    }

    public void setSortKeys(boolean value) {
        this.m_SortKeys = value;
        this.reset();
    }

    public boolean getSortKeys() {
        return this.m_SortKeys;
    }

    public String sortKeysTipText() {
        return "If enabled, the keys of JSONObject objects will get sorted for display.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{JSONAware.class};
    }

    @Override
    protected void display(Token token) {
        this.m_Tree.setJSON((JSONAware)token.getPayload());
        if (this.m_Expand) {
            if (this.m_Tree instanceof JsonTreeWithPreview) {
                ((JsonTreeWithPreview)this.m_Tree).getTree().expandAll();
            } else if (this.m_Tree instanceof JsonTree) {
                ((JsonTree)this.m_Tree).expandAll();
            }
        }
    }

    @Override
    public void clearPanel() {
        if (this.m_Tree != null) {
            this.m_Tree.setJSON(null);
        }
    }

    @Override
    protected BasePanel newPanel() {
        BasePanel result;
        if (this.m_Preview) {
            this.m_Tree = new JsonTreeWithPreview();
            ((JsonTreeWithPreview)this.m_Tree).setSortKeys(this.m_SortKeys);
            result = (BasePanel)((Object)this.m_Tree);
        } else {
            this.m_Tree = new JsonTree();
            ((JsonTree)this.m_Tree).setSortKeys(this.m_SortKeys);
            result = new BasePanel(new BorderLayout());
            result.add((Component)new BaseScrollPane((JComponent)((Object)this.m_Tree)), "Center");
        }
        return result;
    }

    @Override
    public ExtensionFileFilter getCustomTextFileFilter() {
        return new ExtensionFileFilter("JSON", "json");
    }

    @Override
    public String supplyText() {
        if (this.m_Tree != null) {
            return JSONValue.toJSONString((Object)this.m_Tree.getJSON());
        }
        return null;
    }

    @Override
    public DisplayPanel createDisplayPanel(Token token) {
        AbstractTextDisplayPanel result = new AbstractTextDisplayPanel(this.getClass().getSimpleName()){
            private static final long serialVersionUID = 4356468458332186521L;
            protected JsonSupporter m_Tree;

            @Override
            protected void initGUI() {
                super.initGUI();
                if (JsonDisplay.this.m_Preview) {
                    this.m_Tree = new JsonTreeWithPreview();
                    ((JsonTreeWithPreview)this.m_Tree).setSortKeys(JsonDisplay.this.m_SortKeys);
                    this.add((Component)((JComponent)((Object)this.m_Tree)), "Center");
                } else {
                    this.m_Tree = new JsonTree();
                    ((JsonTree)this.m_Tree).setSortKeys(JsonDisplay.this.m_SortKeys);
                    this.add((Component)new BaseScrollPane((JComponent)((Object)this.m_Tree)), "Center");
                }
            }

            @Override
            public void display(Token token) {
                this.m_Tree.setJSON((JSONAware)token.getPayload());
                if (JsonDisplay.this.m_Expand) {
                    if (this.m_Tree instanceof JsonTreeWithPreview) {
                        ((JsonTreeWithPreview)this.m_Tree).getTree().expandAll();
                    } else if (this.m_Tree instanceof JsonTree) {
                        ((JsonTree)this.m_Tree).expandAll();
                    }
                }
            }

            @Override
            public void clearPanel() {
                this.m_Tree.setJSON(null);
            }

            @Override
            public void cleanUp() {
                this.m_Tree.setJSON(null);
            }

            @Override
            public ExtensionFileFilter getCustomTextFileFilter() {
                return new ExtensionFileFilter("JSON", "json");
            }

            @Override
            public String supplyText() {
                if (this.m_Tree != null) {
                    return JSONValue.toJSONString((Object)this.m_Tree.getJSON());
                }
                return null;
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    @Override
    public boolean displayPanelRequiresScrollPane() {
        return false;
    }
}

