/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.DecimalFormatString;
import adams.flow.core.Token;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.gui.core.BasePanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

public class ProgressBar
extends AbstractGraphicalDisplay {
    private static final long serialVersionUID = -4075776040257181463L;
    protected double m_Minimum;
    protected double m_Maximum;
    protected Color m_Bar;
    protected Color m_Background;
    protected Color m_Foreground;
    protected Font m_Font;
    protected DecimalFormatString m_Format;

    @Override
    public String globalInfo() {
        return "Displays a progress bar. The incoming token is used as 'current' value to be displayed.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("min", "minimum", 0.0);
        this.m_OptionManager.add("max", "maximum", 100.0);
        this.m_OptionManager.add("bar", "bar", Color.BLUE);
        this.m_OptionManager.add("background", "background", Color.LIGHT_GRAY);
        this.m_OptionManager.add("foreground", "foreground", Color.WHITE);
        this.m_OptionManager.add("format", "format", new DecimalFormatString("#.#%"));
        this.m_OptionManager.add("font", "font", new Font("helvetica", 1, 16));
    }

    @Override
    protected int getDefaultX() {
        return -3;
    }

    @Override
    protected int getDefaultWidth() {
        return 200;
    }

    @Override
    protected int getDefaultHeight() {
        return 100;
    }

    public void setMinimum(double value) {
        this.m_Minimum = value;
        this.reset();
    }

    public double getMinimum() {
        return this.m_Minimum;
    }

    public String minimumTipText() {
        return "The minimum to use.";
    }

    public void setMaximum(double value) {
        this.m_Maximum = value;
        this.reset();
    }

    public double getMaximum() {
        return this.m_Maximum;
    }

    public String maximumTipText() {
        return "The maximum to use.";
    }

    public void setBar(Color value) {
        this.m_Bar = value;
        this.reset();
    }

    public Color getBar() {
        return this.m_Bar;
    }

    public String barTipText() {
        return "The bar color to use.";
    }

    public void setBackground(Color value) {
        this.m_Background = value;
        this.reset();
    }

    public Color getBackground() {
        return this.m_Background;
    }

    public String backgroundTipText() {
        return "The background color to use.";
    }

    public void setForeground(Color value) {
        this.m_Foreground = value;
        this.reset();
    }

    public Color getForeground() {
        return this.m_Foreground;
    }

    public String foregroundTipText() {
        return "The foreground color to use.";
    }

    public void setFormat(DecimalFormatString value) {
        this.m_Format = value;
        this.reset();
    }

    public DecimalFormatString getFormat() {
        return this.m_Format;
    }

    public String formatTipText() {
        return "The format string to use for outputting the current value, use empty string to suppress output.";
    }

    public void setFont(Font value) {
        this.m_Font = value;
        this.reset();
    }

    public Font getFont() {
        return this.m_Font;
    }

    public String fontTipText() {
        return "The font to use for the current value.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "minimum", this.m_Minimum, "min: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "maximum", this.m_Maximum, ", max: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "format", this.m_Format, ", format: ");
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Number.class};
    }

    @Override
    protected BasePanel newPanel() {
        return new ProgressBarPanel(this);
    }

    @Override
    public void clearPanel() {
        ((ProgressBarPanel)this.m_Panel).reset();
    }

    @Override
    protected void display(Token token) {
        ((ProgressBarPanel)this.m_Panel).update(((Number)token.getPayload()).doubleValue());
    }

    public static class ProgressBarPanel
    extends BasePanel {
        private static final long serialVersionUID = -8123047909195552460L;
        protected ProgressBar m_Owner;
        protected double m_Current;
        protected transient DecimalFormat m_Format;

        public ProgressBarPanel(ProgressBar owner) {
            this.m_Owner = owner;
            this.m_Current = owner.getMinimum();
        }

        public void reset() {
            this.m_Current = this.m_Owner.getMinimum();
            this.repaint();
        }

        public void update(double current) {
            this.m_Current = current;
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            double perc = (this.m_Current - this.m_Owner.getMinimum()) / (this.m_Owner.getMaximum() - this.m_Owner.getMinimum());
            Graphics2D g2d = (Graphics2D)g;
            g.setColor(this.m_Owner.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            double width = perc * (double)this.getWidth();
            g.setColor(this.m_Owner.getBar());
            g.fillRect(0, 0, (int)width, this.getHeight());
            if (this.m_Format == null) {
                this.m_Format = this.m_Owner.getFormat().toDecimalFormat();
            }
            String curr = this.m_Format.format(perc);
            TextLayout layout = new TextLayout(curr, g.getFont(), g2d.getFontRenderContext());
            Rectangle2D bounds = layout.getBounds();
            g.setColor(this.m_Owner.getForeground());
            g.setFont(this.m_Owner.getFont());
            g.drawString(curr, (int)(((double)this.getWidth() - bounds.getWidth()) / 2.0), (int)((double)(this.getHeight() / 2) + bounds.getHeight() / 2.0));
        }
    }
}

