/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.dotnotationtree.DotNotationNode;
import adams.gui.core.dotnotationtree.DotNotationTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;

public class StringTree
extends AbstractGraphicalDisplay {
    private static final long serialVersionUID = 3452547680157056093L;
    protected String m_Separator;
    protected boolean m_Sorted;
    protected HierarchicalStringTree m_Tree;

    @Override
    public String globalInfo() {
        return "Generates a tree from the strings arriving at the input, splitting them into parts using the specified separator. This can be used to display files from various directories in a hierarchical view.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("separator", "separator", ".");
        this.m_OptionManager.add("sorted", "sorted", false);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "separator", this.m_Separator, "separator: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "sorted", this.m_Sorted, "sorted", ", ");
        return result;
    }

    public void setSeparator(String value) {
        this.m_Separator = value;
        this.reset();
    }

    public String getSeparator() {
        return this.m_Separator;
    }

    public String separatorTipText() {
        return "The separator to use for splitting the strings into parts.";
    }

    public void setSorted(boolean value) {
        this.m_Sorted = value;
        this.reset();
    }

    public boolean getSorted() {
        return this.m_Sorted;
    }

    public String sortedTipText() {
        return "Whether to sort the entries in the tree.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, String[].class};
    }

    @Override
    protected void display(Token token) {
        if (this.m_Tree == null) {
            return;
        }
        String[] items = null;
        if (token.getPayload() instanceof String) {
            items = new String[]{(String)token.getPayload()};
        } else if (token.getPayload() instanceof String[]) {
            items = (String[])token.getPayload();
        }
        if (items != null) {
            this.m_Tree.addItems(items);
        }
    }

    @Override
    public void clearPanel() {
        if (this.m_Tree != null) {
            this.m_Tree.setItems(new String[0]);
        }
    }

    @Override
    protected BasePanel newPanel() {
        BasePanel result = new BasePanel(new BorderLayout());
        this.m_Tree = new HierarchicalStringTree(this.m_Separator);
        this.m_Tree.setSorted(this.m_Sorted);
        result.add((Component)new BaseScrollPane(this.m_Tree), "Center");
        return result;
    }

    public static class HierarchicalStringTree
    extends DotNotationTree<HierarchicalStringNode> {
        private static final long serialVersionUID = -646089462979164896L;
        protected String m_Separator;

        public HierarchicalStringTree(String separator) {
            this.m_Separator = separator;
        }

        @Override
        protected String[] splitItem(String item) {
            int pos;
            ArrayList<String> result = new ArrayList<String>();
            String tmp = item;
            while ((pos = tmp.indexOf(this.m_Separator)) > -1) {
                if (pos > 0) {
                    result.add(tmp.substring(0, pos));
                }
                tmp = tmp.substring(pos + this.m_Separator.length());
            }
            if (!tmp.isEmpty()) {
                result.add(tmp);
            }
            return result.toArray(new String[result.size()]);
        }

        @Override
        public String getSeparator() {
            return this.m_Separator;
        }

        @Override
        protected HierarchicalStringNode newNode(String label) {
            return new HierarchicalStringNode(label, this.m_Separator);
        }
    }

    public static class HierarchicalStringNode
    extends DotNotationNode {
        private static final long serialVersionUID = -3163677863942389729L;
        protected String m_Separator;

        public HierarchicalStringNode(String label, String separator) {
            super(label);
            this.m_Separator = separator;
        }

        @Override
        public String getSeparator() {
            return this.m_Separator;
        }
    }
}

