/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.sequenceplotter;

import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.flow.sink.sequenceplotter.ErrorCircleHitDetector;
import adams.flow.sink.sequenceplotter.SequencePlotPoint;
import adams.gui.core.GUIHelper;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.AbstractXYSequencePointHitDetector;
import adams.gui.visualization.sequence.CirclePaintlet;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import java.awt.Color;
import java.awt.Graphics;
import java.util.List;

public class ErrorCirclePaintlet
extends CirclePaintlet {
    private static final long serialVersionUID = -8772546156227148237L;

    @Override
    public String globalInfo() {
        return "Paintlet for painting circles with diameters based on the error at the specified X-Y position. Prefers X errors over Y errors.";
    }

    @Override
    public AbstractXYSequencePointHitDetector newHitDetector() {
        return new ErrorCircleHitDetector(this);
    }

    @Override
    public void drawCustomData(Graphics g, PaintEvent.PaintMoment moment, XYSequence data, Color color) {
        List points = data.toList();
        AxisPanel axisX = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisY = this.getPanel().getPlot().getAxis(Axis.LEFT);
        g.setColor(color);
        GUIHelper.configureAntiAliasing(g, this.m_AntiAliasingEnabled);
        int currX = Integer.MIN_VALUE;
        int currY = Integer.MIN_VALUE;
        for (int i = 0; i < data.size(); ++i) {
            XYSequencePoint curr = (XYSequencePoint)points.get(i);
            currX = axisX.valueToPos(XYSequencePoint.toDouble(curr.getX()));
            currY = axisY.valueToPos(XYSequencePoint.toDouble(curr.getY()));
            int diameter = this.getDiameter(axisX, axisY, currX, currY, curr);
            g.drawOval(currX -= diameter / 2, currY -= diameter / 2, diameter - 1, diameter - 1);
        }
    }

    public int getDiameter(XYSequencePoint curr) {
        AxisPanel axisX = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisY = this.getPanel().getPlot().getAxis(Axis.LEFT);
        return this.getDiameter(axisX, axisY, curr);
    }

    public int getDiameter(AxisPanel axisX, AxisPanel axisY, XYSequencePoint curr) {
        double currX = axisX.valueToPos(XYSequencePoint.toDouble(curr.getX()));
        double currY = axisY.valueToPos(XYSequencePoint.toDouble(curr.getY()));
        return this.getDiameter(axisX, axisY, currX, currY, curr);
    }

    public int getDiameter(AxisPanel axisX, AxisPanel axisY, double currX, double currY, XYSequencePoint curr) {
        int diameter = this.m_Diameter;
        if (curr instanceof SequencePlotPoint) {
            SequencePlotPoint ppoint = (SequencePlotPoint)curr;
            if (ppoint.hasErrorX()) {
                Double[] errors = ppoint.getErrorX();
                diameter = errors.length == 1 ? Math.max(diameter, axisX.valueToPos(currX - errors[0]) - axisX.valueToPos(currX + errors[0])) : Math.max(diameter, axisX.valueToPos(errors[1]) - axisX.valueToPos(errors[0]));
            } else if (ppoint.hasErrorY()) {
                Double[] errors = ppoint.getErrorY();
                diameter = errors.length == 1 ? Math.max(diameter, axisY.valueToPos(currY - errors[0]) - axisY.valueToPos(currY + errors[0])) : Math.max(diameter, axisY.valueToPos(errors[1]) - axisY.valueToPos(errors[0]));
            }
        }
        return diameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        XYSequenceContainerManager xYSequenceContainerManager = this.getActualContainerManager();
        synchronized (xYSequenceContainerManager) {
            for (int i = 0; i < this.getActualContainerManager().count(); ++i) {
                XYSequence data;
                if (!this.getActualContainerManager().isVisible(i) || (data = ((XYSequenceContainer)this.getActualContainerManager().get(i)).getData()).size() == 0) continue;
                XYSequence xYSequence = data;
                synchronized (xYSequence) {
                    this.drawCustomData(g, moment, data, this.getColor(i));
                    continue;
                }
            }
        }
    }
}

