/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseString;
import adams.core.option.OptionHandler;
import adams.flow.core.AutomatableInteractiveActor;
import adams.flow.source.AbstractInteractiveArrayProvider;
import java.util.ArrayList;

public abstract class AbstractSelectObjects
extends AbstractInteractiveArrayProvider
implements AutomatableInteractiveActor {
    private static final long serialVersionUID = 8791403891812271704L;
    protected String m_SuperClass;
    protected BaseString[] m_InitialObjects;
    protected boolean m_NonInteractive;
    protected boolean m_ShortTitle;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("super-class", "superClass", this.getDefaultSuperClass());
        this.m_OptionManager.add("initial-objects", "initialObjects", this.getDefaultInitialObjects());
        this.m_OptionManager.add("non-interactive", "nonInteractive", false);
        this.m_OptionManager.add("short-title", "shortTitle", false);
    }

    protected String getDefaultSuperClass() {
        return Object.class.getName();
    }

    public void setSuperClass(String value) {
        this.m_SuperClass = value;
        this.reset();
    }

    public String getSuperClass() {
        return this.m_SuperClass;
    }

    public String superClassTipText() {
        return "The superclass for the class hierarchy.";
    }

    public BaseString[] getDefaultInitialObjects() {
        return new BaseString[0];
    }

    public void setInitialObjects(BaseString[] value) {
        this.m_InitialObjects = value;
        this.reset();
    }

    public BaseString[] getInitialObjects() {
        return this.m_InitialObjects;
    }

    public String initialObjectsTipText() {
        return "The initial objects to populate the dialog with.";
    }

    @Override
    public void setNonInteractive(boolean value) {
        this.m_NonInteractive = value;
        this.reset();
    }

    @Override
    public boolean isNonInteractive() {
        return this.m_NonInteractive;
    }

    @Override
    public String nonInteractiveTipText() {
        return "If enabled, the initial objects are forwarded without user interaction.";
    }

    public void setShortTitle(boolean value) {
        this.m_ShortTitle = value;
        this.reset();
    }

    public boolean getShortTitle() {
        return this.m_ShortTitle;
    }

    public String shortTitleTipText() {
        return "If enabled uses just the name for the title instead of the actor's full name.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "superClass", this.m_SuperClass, "super: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "initialObjects", this.m_InitialObjects.length == 1 ? this.m_InitialObjects[0].getValue() : this.m_InitialObjects.length + " objects", ", initial: ");
        ArrayList<String> options = new ArrayList<String>();
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "outputArray", this.m_OutputArray, "as array"));
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "stopFlowIfCanceled", this.m_StopFlowIfCanceled, "stops flow if canceled"));
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "nonInteractive", this.m_NonInteractive, "non-interactive"));
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "shortTitle", this.m_ShortTitle, "short title"));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    protected abstract Object commandlineToObject(String var1);

    protected abstract void initializeDialog();

    protected abstract Object[] showDialog();

    @Override
    public boolean doInteract() {
        this.m_Queue.clear();
        this.initializeDialog();
        Object[] selected = this.showDialog();
        if (selected == null) {
            return false;
        }
        if (this.m_Stopped) {
            return true;
        }
        for (Object sel : selected) {
            this.m_Queue.add(sel);
        }
        return true;
    }

    @Override
    protected String doExecute() {
        String result = null;
        if (this.isHeadless() || this.m_NonInteractive) {
            for (BaseString initial : this.m_InitialObjects) {
                Object obj = this.commandlineToObject(initial.getValue());
                if (obj == null) {
                    this.getLogger().warning("Failed to convert commandline into object: " + initial);
                    continue;
                }
                this.m_Queue.add(obj);
            }
        } else {
            result = super.doExecute();
        }
        return result;
    }
}

