/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.control.StorageName;
import adams.flow.control.StorageQueueHandler;
import adams.flow.control.StorageUpdater;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.source.AbstractSource;

public class DeQueue
extends AbstractSource
implements StorageUpdater {
    private static final long serialVersionUID = 6216146938771296415L;
    protected StorageName m_StorageName;
    protected int m_Interval;

    @Override
    public String globalInfo() {
        return "Polls the specified queue in internal storage for an item, blocks till an item is available.\nNB: The user needs to stop the flow as the DeQueue source will never stop, as it assumes that there will be more data coming through.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", new StorageName("queue"));
        this.m_OptionManager.add("interval", "interval", 50, 1, null);
    }

    @Override
    public boolean isUpdatingStorage() {
        return !this.getSkip();
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "storageName", this.m_StorageName, "storage: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "interval", this.m_Interval, ", interval: ");
        return result;
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the queue in the internal storage.";
    }

    public void setInterval(int value) {
        this.m_Interval = value;
        this.reset();
    }

    public int getInterval() {
        return this.m_Interval;
    }

    public String intervalTipText() {
        return "The polling interval in milli-seconds.";
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        if (!this.getStorageHandler().getStorage().has(this.m_StorageName)) {
            result = "Queue '" + this.m_StorageName + "' not available from internal storage!";
        }
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_Executed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token output() {
        Token result = null;
        StorageQueueHandler queue = (StorageQueueHandler)this.getStorageHandler().getStorage().get(this.m_StorageName);
        while (result == null && !this.m_Stopped) {
            try {
                if (queue.size() > 0) {
                    result = new Token(queue.remove());
                    continue;
                }
                DeQueue deQueue = this;
                synchronized (deQueue) {
                    this.wait(this.m_Interval);
                }
            }
            catch (Exception exception) {
            }
        }
        return result;
    }
}

