/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.VariableName;
import adams.core.VariableUser;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;

public class VariablesArray
extends AbstractSource
implements VariableUser {
    private static final long serialVersionUID = -8533328604800956145L;
    protected VariableName[] m_VariableNames;
    protected String[] m_StoredValue;

    @Override
    public String globalInfo() {
        return "Outputs the values associated with the specified variable names as a string array.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("var-name", "variableNames", new VariableName[0]);
    }

    public void setVariableNames(VariableName[] value) {
        this.m_VariableNames = value;
        this.reset();
    }

    public VariableName[] getVariableNames() {
        return this.m_VariableNames;
    }

    public String variableNamesTipText() {
        return "The names of the variables to retrieve as array.";
    }

    @Override
    public boolean isUsingVariables() {
        return !this.getSkip() && this.m_VariableNames.length > 0;
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "variableNames", Utils.flatten(this.m_VariableNames, ", "), "Names: ");
        if (result == null) {
            result = "-no names specified-";
        }
        return result;
    }

    @Override
    public Class[] generates() {
        return new Class[]{String[].class};
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_StoredValue = null;
    }

    @Override
    protected String performSetUpChecks(boolean fromSetUp) {
        String result = super.performSetUpChecks(fromSetUp);
        if (result == null && this.canPerformSetUpCheck(fromSetUp, "variableNames") && (this.m_VariableNames == null || this.m_VariableNames.length == 0)) {
            result = "No names specified for variables!";
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        String[] values = new String[this.m_VariableNames.length];
        for (int i = 0; i < this.m_VariableNames.length; ++i) {
            if (this.getVariables().has(this.m_VariableNames[i].getValue())) {
                values[i] = this.getVariables().get(this.m_VariableNames[i].getValue());
            } else {
                result = "Storage item #" + (i + 1) + " (" + this.m_VariableNames[i] + ") not found!";
            }
            if (result != null) break;
        }
        this.m_StoredValue = result == null ? values : null;
        return result;
    }

    @Override
    public Token output() {
        Token result = new Token(this.m_StoredValue);
        this.m_StoredValue = null;
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_StoredValue != null;
    }
}

