/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source.filesystemsearch;

import adams.core.base.BaseDateTime;
import adams.flow.source.filesystemsearch.DirectorySearch;

public class DirectorySearchWithTimestampConstraints
extends DirectorySearch {
    private static final long serialVersionUID = 7165242885787887905L;

    @Override
    public String globalInfo() {
        return super.globalInfo() + "\n" + "Allows to further restrict the search using a timestamp window " + "('last modified') that the directories must satisfy.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("min-timestamp", "minTimestamp", new BaseDateTime("-INF"));
        this.m_OptionManager.add("max-timestamp", "maxTimestamp", new BaseDateTime("+INF"));
    }

    public void setMinTimestamp(BaseDateTime value) {
        this.m_Lister.setMinFileTimestamp(value);
        this.reset();
    }

    public BaseDateTime getMinTimestamp() {
        return this.m_Lister.getMinFileTimestamp();
    }

    public String minTimestampTipText() {
        return "The minimum 'last modified' timestamp that the directories can have.";
    }

    public void setMaxTimestamp(BaseDateTime value) {
        this.m_Lister.setMaxFileTimestamp(value);
        this.reset();
    }

    public BaseDateTime getMaxTimestamp() {
        return this.m_Lister.getMaxFileTimestamp();
    }

    public String maxTimestampTipText() {
        return "The maximum 'last modified' timestamp that the directories can have.";
    }
}

