/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source.filesystemsearch;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.io.DirectoryLister;
import adams.core.io.PlaceholderDirectory;
import adams.core.option.OptionHandler;
import adams.flow.source.filesystemsearch.AbstractDirectoryListerBasedSearchlet;
import java.util.ArrayList;

public class FileSearch
extends AbstractDirectoryListerBasedSearchlet {
    private static final long serialVersionUID = 3229293554987103145L;

    @Override
    public String globalInfo() {
        return "Searches only for files.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("directory", "directory", new PlaceholderDirectory("."));
        this.m_OptionManager.add("max-items", "maxItems", -1);
        this.m_OptionManager.add("regexp", "regExp", new BaseRegExp(""));
        this.m_OptionManager.add("sorting", "sorting", (Object)DirectoryLister.Sorting.NO_SORTING);
        this.m_OptionManager.add("descending", "sortDescending", false);
        this.m_OptionManager.add("recursive", "recursive", false);
        this.m_OptionManager.add("max-depth", "maxDepth", -1);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Lister.setListDirs(false);
        this.m_Lister.setListFiles(true);
    }

    public void setDirectory(PlaceholderDirectory value) {
        this.m_Lister.setWatchDir(value);
    }

    public PlaceholderDirectory getDirectory() {
        return this.m_Lister.getWatchDir();
    }

    public String directoryTipText() {
        return "The directory to search for files.";
    }

    public void setMaxItems(int value) {
        this.m_Lister.setMaxItems(value);
        this.reset();
    }

    public int getMaxItems() {
        return this.m_Lister.getMaxItems();
    }

    public String maxItemsTipText() {
        return "The maximum number of files to return (<= 0 is unlimited).";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_Lister.setRegExp(value);
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_Lister.getRegExp();
    }

    public String regExpTipText() {
        return "The regular expression that the files must match (empty string matches all).";
    }

    public void setSorting(DirectoryLister.Sorting value) {
        this.m_Lister.setSorting(value);
        this.reset();
    }

    public DirectoryLister.Sorting getSorting() {
        return this.m_Lister.getSorting();
    }

    public String sortingTipText() {
        return "The type of sorting to perform.";
    }

    public void setSortDescending(boolean value) {
        this.m_Lister.setSortDescending(value);
        this.reset();
    }

    public boolean getSortDescending() {
        return this.m_Lister.getSortDescending();
    }

    public String sortDescendingTipText() {
        return "If set to true, the files are sorted in descending manner.";
    }

    public void setRecursive(boolean value) {
        this.m_Lister.setRecursive(value);
        this.reset();
    }

    public boolean getRecursive() {
        return this.m_Lister.getRecursive();
    }

    public String recursiveTipText() {
        return "Whether to search recursively or not.";
    }

    public void setMaxDepth(int value) {
        this.m_Lister.setMaxDepth(value);
        this.reset();
    }

    public int getMaxDepth() {
        return this.m_Lister.getMaxDepth();
    }

    public String maxDepthTipText() {
        return "The maximum depth to search in recursive mode (1 = only watch directory, -1 = infinite).";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "directory", this.getDirectory());
        ArrayList<String> options = new ArrayList<String>();
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "sorting", (Object)this.getSorting()));
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "sortDescending", this.getSorting() != DirectoryLister.Sorting.NO_SORTING && this.getSortDescending(), "descending"));
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "recursive", this.getRecursive(), "recursive"));
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "maxItems", this.getMaxItems() > 0 ? Integer.valueOf(this.getMaxItems()) : null, "max="));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }
}

