/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.control.StorageName;
import adams.flow.control.StorageUpdater;
import adams.flow.standalone.AbstractStandalone;
import java.util.HashSet;

public class HashSetInit
extends AbstractStandalone
implements StorageUpdater {
    private static final long serialVersionUID = 4182914190162129217L;
    protected StorageName m_StorageName;

    @Override
    public String globalInfo() {
        return "Creates an empty hashset in internal storage under the specified name.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", new StorageName("hashset"));
    }

    @Override
    public boolean isUpdatingStorage() {
        return !this.getSkip();
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "storageName", this.m_StorageName, "storage: ");
        return result;
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the hashset in the internal storage.";
    }

    @Override
    protected String doExecute() {
        this.getStorageHandler().getStorage().put(this.m_StorageName, new HashSet());
        return null;
    }
}

