/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import adams.flow.core.AbstractActor;
import adams.flow.sink.CallableSink;
import adams.flow.sink.ComponentSupplier;
import adams.flow.sink.TextSupplier;
import adams.flow.standalone.AbstractMultiView;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.ExtensionFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class TabView
extends AbstractMultiView
implements ComponentSupplier,
TextSupplier,
SpreadSheetSupporter {
    private static final long serialVersionUID = -4454052058077687116L;
    protected BaseTabbedPane m_TabbedPane;

    @Override
    public String globalInfo() {
        return "Displays multiple graphical actors in a tabbed pane. The actors can be referenced in the flow using " + CallableSink.class.getName() + " actors.";
    }

    @Override
    public String actorsTipText() {
        return "The panel-generating actors to display in the tabbed pane.";
    }

    @Override
    public boolean makeVisible(AbstractMultiView.ViewWrapper wrapper) {
        int index;
        if (this.m_Wrappers != null && (index = this.m_Wrappers.indexOf(wrapper)) > -1) {
            this.m_TabbedPane.setSelectedIndex(index);
            return true;
        }
        return false;
    }

    @Override
    protected BasePanel newPanel() {
        BasePanel result = new BasePanel(new BorderLayout());
        this.m_TabbedPane = new BaseTabbedPane();
        result.add((Component)this.m_TabbedPane, "Center");
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            BasePanel panel = new BasePanel(new BorderLayout());
            JLabel label = new JLabel(((AbstractActor)this.m_Actors.get(i)).getName(), 0);
            panel.add((Component)label, "Center");
            this.m_TabbedPane.addTab(((AbstractActor)this.m_Actors.get(i)).getName(), panel);
        }
        return result;
    }

    @Override
    public void addPanel(AbstractActor actor, BasePanel panel) {
        int index = this.indexOf(actor.getName());
        this.m_TabbedPane.setComponentAt(index, panel);
    }

    @Override
    public JComponent supplyComponent() {
        int index = this.m_TabbedPane.getSelectedIndex();
        if (index > -1) {
            if (this.m_Actors.get(index) instanceof ComponentSupplier) {
                return ((ComponentSupplier)this.m_Actors.get(index)).supplyComponent();
            }
            if (this.m_TabbedPane.getComponentAt(index) instanceof JComponent) {
                return (JComponent)this.m_TabbedPane.getComponentAt(index);
            }
        }
        return null;
    }

    @Override
    public ExtensionFileFilter getCustomTextFileFilter() {
        int index = this.m_TabbedPane.getSelectedIndex();
        if (index > -1 && this.m_Actors.get(index) instanceof TextSupplier) {
            return ((TextSupplier)this.m_Actors.get(index)).getCustomTextFileFilter();
        }
        return null;
    }

    @Override
    public String supplyText() {
        int index = this.m_TabbedPane.getSelectedIndex();
        if (index > -1 && this.m_Actors.get(index) instanceof TextSupplier) {
            return ((TextSupplier)this.m_Actors.get(index)).supplyText();
        }
        return null;
    }

    @Override
    public SpreadSheet toSpreadSheet() {
        int index = this.m_TabbedPane.getSelectedIndex();
        if (index > -1 && this.m_Actors.get(index) instanceof SpreadSheetSupporter) {
            return ((SpreadSheetSupporter)this.m_Actors.get(index)).toSpreadSheet();
        }
        return null;
    }
}

