/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.report.Report;
import adams.db.ReportProvider;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractDbTransformer;
import adams.flow.transformer.report.AbstractReportPostProcessor;
import adams.flow.transformer.report.NoPostProcessing;

public abstract class AbstractReportDbReader<T extends Report>
extends AbstractDbTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = 7352720726300796621L;
    protected AbstractReportPostProcessor m_PostProcessor;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("post-processor", "postProcessor", new NoPostProcessing());
    }

    public void setPostProcessor(AbstractReportPostProcessor value) {
        this.m_PostProcessor = value;
        this.reset();
    }

    public AbstractReportPostProcessor getPostProcessor() {
        return this.m_PostProcessor;
    }

    public String postProcessorTipText() {
        return "The post-processor to apply to the data.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Integer.class};
    }

    @Override
    public abstract Class[] generates();

    protected abstract ReportProvider<T> getReportProvider();

    @Override
    protected String queryDatabase() {
        String result = null;
        int id = (Integer)this.m_InputToken.getPayload();
        ReportProvider<T> provider = this.getReportProvider();
        T report = provider.load(id);
        if (report == null) {
            result = "No report loaded for ID: " + this.m_InputToken;
        } else {
            this.m_OutputToken = new Token(this.m_PostProcessor.postProcess(report));
        }
        if (this.m_OutputToken != null) {
            this.updateProvenance(this.m_OutputToken);
        }
        return result;
    }

    @Override
    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.addProvenance(new ProvenanceInformation(ActorType.DATAGENERATOR, this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

