/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ClassCrossReference;
import adams.core.QuickInfoHelper;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.BaseName;
import adams.flow.transformer.DirName;
import adams.flow.transformer.FileExtension;
import adams.flow.transformer.PrependDir;
import java.io.File;
import java.util.ArrayList;

public class AppendName
extends AbstractTransformer
implements ClassCrossReference {
    private static final long serialVersionUID = 4670761846363281951L;
    protected String m_Suffix;
    protected boolean m_NoSeparator;

    @Override
    public String globalInfo() {
        return "Appends the suffix to the file/directory being passed through.\n By default, the appropriate separator (forward slash or backslash) gets inserted between the file/directory and suffix. This can be turned off.\n";
    }

    @Override
    public Class[] getClassCrossReferences() {
        return new Class[]{PrependDir.class, BaseName.class, DirName.class, FileExtension.class};
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("suffix", "suffix", "");
        this.m_OptionManager.add("no-separator", "noSeparator", false);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "suffix", this.m_Suffix);
        if (result == null) {
            result = "";
        }
        ArrayList<String> options = new ArrayList<String>();
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "noSeparator", this.m_NoSeparator, "no separator"));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    public void setSuffix(String value) {
        this.m_Suffix = value;
        this.reset();
    }

    public String getSuffix() {
        return this.m_Suffix;
    }

    public String suffixTipText() {
        return "The suffix to append to the file/directory.";
    }

    public void setNoSeparator(boolean value) {
        this.m_NoSeparator = value;
        this.reset();
    }

    public boolean getNoSeparator() {
        return this.m_NoSeparator;
    }

    public String noSeparatorTipText() {
        return "If enabled, no separator (forward slash or backslash) gets inserted between file/directory and suffix.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, String[].class, File.class, File[].class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class, String[].class, File.class, File[].class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        boolean array = this.m_InputToken.getPayload().getClass().isArray();
        boolean string = this.m_InputToken.getPayload() instanceof String || this.m_InputToken.getPayload() instanceof String[];
        PlaceholderFile[] files = FileUtils.toPlaceholderFileArray(this.m_InputToken.getPayload());
        String[] strings = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = this.m_NoSeparator ? new PlaceholderFile(files[i].getAbsolutePath() + this.m_Suffix) : new PlaceholderFile(files[i].getAbsolutePath() + File.separator + this.m_Suffix);
            if (!string) continue;
            strings[i] = files[i].toString();
        }
        this.m_OutputToken = string ? (array ? new Token(strings) : new Token(strings[0])) : (array ? new Token(files) : new Token(files[0]));
        return result;
    }
}

