/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ClassCrossReference;
import adams.core.QuickInfoHelper;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.AppendName;
import adams.flow.transformer.BaseName;
import adams.flow.transformer.DirName;
import adams.flow.transformer.PrependDir;
import java.io.File;

public class FileExtension
extends AbstractTransformer
implements ClassCrossReference {
    private static final long serialVersionUID = -2838258525424174583L;
    protected boolean m_IncludeDot;

    @Override
    public String globalInfo() {
        return "Extracts the file extension from the file (the part after the '.').\nIf no dot is in the file name, then an empty string gets forwarded.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("include-dot", "includeDot", false);
    }

    public void setIncludeDot(boolean value) {
        this.m_IncludeDot = value;
        this.reset();
    }

    public boolean getIncludeDot() {
        return this.m_IncludeDot;
    }

    public String includeDotTipText() {
        return "If true, then the dot gets returned as well.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "includeDot", this.m_IncludeDot, "incl. dot");
    }

    @Override
    public Class[] getClassCrossReferences() {
        return new Class[]{AppendName.class, PrependDir.class, DirName.class, BaseName.class};
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, String[].class, File.class, File[].class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class, String[].class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        boolean array = this.m_InputToken.getPayload().getClass().isArray();
        PlaceholderFile[] files = FileUtils.toPlaceholderFileArray(this.m_InputToken.getPayload());
        String[] strings = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            strings[i] = files[i].getName();
            strings[i] = FileUtils.removeIgnoredExtensionSuffixes(strings[i]);
            int pos = strings[i].lastIndexOf(46);
            if (pos > -1) {
                if (this.m_IncludeDot) {
                    strings[i] = files[i].getName().substring(pos, files[i].getName().length());
                    continue;
                }
                strings[i] = files[i].getName().substring(pos + 1, files[i].getName().length());
                continue;
            }
            strings[i] = "";
        }
        this.m_OutputToken = array ? new Token(strings) : new Token(strings[0]);
        return result;
    }
}

