/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class SequenceToArray
extends AbstractTransformer {
    private static final long serialVersionUID = 8411367398473311627L;
    public static final String BACKUP_ELEMENTS = "elements";
    protected List m_Elements;
    protected int m_ArrayLength;
    protected String m_ArrayClass;

    @Override
    public String globalInfo() {
        return "Turns a sequence of tokens into arrays with a specified length.\nIn case of unspecified length (ie -1), an array containing all elements collected so far is output each time a token arrives, i.e., the internal buffer never gets reset.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("length", "arrayLength", 1, -1, null);
        this.m_OptionManager.add("array-class", "arrayClass", "");
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "arrayLength", this.m_ArrayLength, "Length: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "arrayClass", this.m_ArrayClass.length() != 0 ? this.m_ArrayClass : "-from 1st element-", ", Class: ");
        return result;
    }

    public void setArrayLength(int value) {
        if (value > 0 || value == -1) {
            this.m_ArrayLength = value;
            this.reset();
        } else {
            this.getLogger().severe("Arrays must have a length of at least 1 (or -1 for unspecified length), provided: " + value + "!");
        }
    }

    public int getArrayLength() {
        return this.m_ArrayLength;
    }

    public String arrayLengthTipText() {
        return "The length of the output array; use -1 to output an array with all collected elements so far whenever a token arrives.";
    }

    public void setArrayClass(String value) {
        this.m_ArrayClass = value;
        this.reset();
    }

    public String getArrayClass() {
        return this.m_ArrayClass;
    }

    public String arrayClassTipText() {
        return "The class to use for the array; if none is specified, the class of the first element is used.";
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_ELEMENTS);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_ELEMENTS, this.m_Elements);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_ELEMENTS)) {
            this.m_Elements = (List)state.get(BACKUP_ELEMENTS);
            state.remove(BACKUP_ELEMENTS);
        }
        super.restoreState(state);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Elements = new ArrayList();
        this.m_OutputToken = null;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown[].class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            this.m_Elements.add(this.m_InputToken.getPayload());
            this.getLogger().info("Buffered elements: " + this.m_Elements.size());
            if (this.m_ArrayLength == -1 || this.m_Elements.size() == this.m_ArrayLength) {
                Object array = this.m_ArrayClass.length() == 0 ? Array.newInstance(this.m_Elements.get(0).getClass(), this.m_Elements.size()) : Utils.newArray(this.m_ArrayClass, this.m_Elements.size());
                this.getLogger().info("Array type: " + array.getClass().getComponentType());
                for (int i = 0; i < this.m_Elements.size(); ++i) {
                    Array.set(array, i, this.m_Elements.get(i));
                }
                this.m_OutputToken = new Token(array);
                if (this.m_ArrayLength > -1) {
                    this.m_Elements.clear();
                }
                this.getLogger().info("Array generated");
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to turn sequence into array: ", e);
        }
        return result;
    }
}

